{!! Form::open([
    'class' => '',
    'route' => 'lang.convert.post'
]) !!}
<div class="box-body">
    <div class="form-group col-lg-6 {{ $errors->has('source') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('source', trans("Lang::lang.inputs.source"), ['class' => '']) !!}
        {!! Form::select('source', trans('Core::lang.language-picker.langs'), null, ['placeholder' => trans('Lang::lang.inputs.source_placeholder'), 'id' => 'sourceLang', 'class' => 'form-control basic', 'required' => 'required']) !!}
        {!! $errors->first('source', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-6 {{ $errors->has('destination') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('destination', trans("Lang::lang.inputs.destination"), ['class' => '']) !!}
        {!! Form::select('destination', trans('Core::lang.language-picker.langs'), null, ['placeholder' => trans('Lang::lang.inputs.destination_placeholder'), 'id' => 'destinationLang', 'class' => 'form-control basic', 'required' => 'required']) !!}
        {!! $errors->first('destination', '<span class="help-block">:message</span>') !!}
    </div>
    <div class="col-lg-3">
        <div class="form-group">
            {!! Form::submit($submitButton, ['class' => 'btn btn-success form-control']) !!}
        </div>
    </div>
</div>
{{ Form::close() }}


@push('headerAssetPush')
    <link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
    <style type="text/css">
        .select2-container .select2-selection--single {
            height: 34px !important;
        }
        .select2-container--default .select2-selection--single {
            border-radius: 0px !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 34px !important;
        }
    </style>
@endpush

@push('footerAssetPush')
    <script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
    <script type="application/javascript">
        $("#sourceLang").select2();
        $("#destinationLang").select2();
    </script>
@endpush