@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-language"></i> {{ trans('Lang::lang.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Lang::lang.optional_title.create') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('lang') }}"><i class="fa fa-language"></i>{{ trans('Lang::lang.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Lang::lang.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <div class="row">
                        @include('Lang::_form', ['submitButton' => trans("Lang::lang.buttons.save")])
                    </div>
                    {{--{{ dd(trans('Core::menus.language-picker.langs')) }}--}}
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>
@endsection


@push('footerAssetPush')

@endpush