<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Message\Controllers;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Modules\Iauth\Models\Access\User\User;
use Modules\Iauth\Repositories\Access\User\UserRepositoryContract;
use Modules\Message\Repositories\MessageRepository;
use Nahid\Talk\Facades\Talk;
use Alert;

class MessageController extends Controller
{
    protected $messageRepo;

    protected $userRepo;

    function __construct(MessageRepository $message, UserRepositoryContract $user)
    {
        $this->messageRepo  = $message;
        $this->userRepo     = $user;

        $this->middleware(function ($request, $next) {
            Talk::setAuthUserId(auth()->user()->id);
            return $next($request);
        });
        view()->composer(['Message::layout'], function ($view) {
            $inbox = Talk::getInbox()->all();
            $lastConversation = !empty($inbox) ? Talk::getConversationsByUserId($inbox[0]->withUser->id) : [];
//            dd($lastConversation);
            $view->withUsers($this->userRepo->getAllUsers())
                ->withMessages(!empty($lastConversation->messages) ? $lastConversation->messages : [])
                ->withLastChatUser(!empty($inbox) ? $inbox[0]->withUser : (object) ['id' => 0, 'name' => ''])
                ->withLastConversationId(!empty($inbox) ? $inbox[0]->thread->conversation_id : 0)
                ->withInbox(!empty($inbox) ? $inbox : []);
        });
    }

    public function index()
    {
        return view("Message::layout");
    }

    public function readMessage(Request $request)
    {
        return $this->messageInfo($request['userID']);
    }

    public function send(Request $request)
    {
        $reciverID  = $request['reciverID'];
        $message    = $request['message'];
        $send       = Talk::sendMessageByUserId($reciverID, $message);

        if($send) {
            return $this->messageInfo($reciverID);
        }
    }

    protected function messageInfo($userID)
    {
        $ajaxView       = [];
        $conversation   = Talk::getConversationsByUserId($userID);
        $messages       = !empty($conversation) ? $conversation->messages : [];
        $inbox          = Talk::getInbox()->all();
        $user           = !empty($conversation) ? $conversation->withUser : User::find($userID);

        if($messages != false) {
            $conversationID = $messages[0]->conversation_id;
        } else {
            $conversationID = 0;
        }

        $ajaxView['messages']       = view("Message::conversation", compact('messages'))->render();
        $ajaxView['inbox']          = view("Message::inboxChild")->withInbox($inbox)->render();
        $ajaxView['userFullName']   = $user->name == null || $user->name == ' ' ? $user->username : $user->name;
        $ajaxView['conversationID'] = $conversationID;
        return $ajaxView;
    }

    public function deleteConversation($id)
    {
        if(!empty(Talk::getConversationsById($id))) {
            Talk::deleteConversations($id);
            Alert::success(trans("Message::message.alert.delete_success"), trans("Message::message.alert.delete_success_two"));
        } else {
            Alert::error(trans("Message::message.alert.delete_error"), trans("Message::message.alert.delete_error_two"));
        }

        return redirect()->back();
    }

}
