<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Notice\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Notice\Models\Traits\Attribute\NoticeAttribute;
use Modules\Notice\Models\Traits\Relationship\NoticeRelationship;
use Cache;

class Notice extends Model
{
    use NoticeRelationship, NoticeAttribute;

    protected $table = 'notices';

    protected $guarded = [];

    protected $hidden = [];

    public function seen()
    {
        return Cache::remember('notice_alerts_seen', 30, function () {
            return NoticeAlert::where('user_id', '=', auth()->user()->id)->get()->pluck('seen', 'notice_id')->all();
        });
    }

}
