<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Notice\Services;

use Illuminate\Support\Facades\Auth;
use Modules\Notice\Models\Notice;
use Modules\Notice\Models\NoticeAlert as NoticeAlertModel;
use Cache;

class NoticeAlert
{
    protected $allNotice;
    protected $userNoticeAlerts;

    public function __construct()
    {
        $this->userNoticeAlerts = Cache::remember('notice_alerts_all', 60, function () {
            return NoticeAlertModel::where('user_id', '=', auth()->user()->id )->orderBy('id', 'desc')
                ->get()->pluck('notice_id');
        });
    }

    public function getAllNotice()
    {
        return Cache::remember('notice', 10, function () {
            return Notice::orderBy('id', 'desc')->get();
        });
    }

    public function getNoticeAlertAll()
    {
        return $this->userNoticeAlerts;
    }


}