<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\PaymentType\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\PaymentType\Models\PaymentType;
use Modules\PaymentType\Repositories\PaymentTypeRepository;
use Modules\PaymentType\Requests\PaymentTypeRequest;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;

class PaymentTypeController extends Controller
{
    protected $paymenttypeRepo;

    function __construct(PaymentTypeRepository $paymenttype)
    {
        $this->paymenttypeRepo = $paymenttype;
    }

    public function index()
    {
        return view("PaymentType::paymenttypeList");
    }

    public function paymenttypeDataTable()
    {
        return DataTables::of($this->paymenttypeRepo->findAll(['*']))
            ->editColumn('note', function ($paymenttype){
                $lenth = strlen($paymenttype->note);
                if ($lenth > 99)
                    return substr($paymenttype->note, 0, 100)."...";
                else
                    return $paymenttype->note;
            })
            ->addColumn('actions', function ($paymenttype){
                return $paymenttype->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        return view("PaymentType::paymenttypeCreate");
    }

    public function create(PaymentTypeRequest $request)
    {
        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $result = $this->paymenttypeRepo->create($input);

        if ($result) {
            $this->removeCached();
            flash('PaymentType successfully created!', 'success');
            return redirect()->route('paymenttype.list');
        }
    }

    public function edit(PaymentType $paymenttype)
    {
        return view("PaymentType::paymenttypeEdit")->withPaymenttype($paymenttype);
    }

    public function update(PaymentType $paymenttype, PaymentTypeRequest $request)
    {
        $result = $this->paymenttypeRepo->update($paymenttype, $request->all());

        if ($result) {
            $this->removeCached();
            flash('PaymentType successfully created!', 'success');
            return redirect()->route('paymenttype.list');
        }
    }

    public function view(PaymentType $paymenttype)
    {
        return $paymenttype != null ? view("PaymentType::paymenttypeView")->withPaymenttype($paymenttype) :  abort(404);
    }

    public function status(PaymentType $paymenttype)
    {
        $data = [];
        if($paymenttype->user_id == auth()->user()->id) {
            if ($paymenttype->status==1) {
                $data['status'] = 0;
            } else {
                $data['status'] = 1;
            }
            $this->paymenttypeRepo->update($paymenttype->id, $data);
            $this->removeCached();
            Alert::success(trans("PaymentType::paymenttype.alert.status_success"), 'success');
        } else {
            Alert::error(trans("PaymentType::paymenttype.alert.status_error"), 'error');
        }

        return redirect()->route('paymenttype.list');
    }

    public function delete(PaymentType $paymenttype)
    {
        if($paymenttype->user_id == auth()->user()->id) {

            $this->paymenttypeRepo->delete($paymenttype->id);

            $this->removeCached();
            Alert::success(trans("PaymentType::paymenttype.alert.delete_success"), 'success');
            return redirect()->route('paymenttype.list');
        } else {
            $this->removeCached();
            Alert::error(trans("PaymentType::paymenttype.alert.delete_error"), 'Error');
            return redirect()->route('paymenttype.list');
        }
    }

    public function removeCached()
    {
        Cache::forget('payment_types');
    }


}
