<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'PaymentType', 'prefix' => 'admin/type', 'namespace' => '\Modules\PaymentType\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {


    Route::get('/', 'PaymentTypeController@index')->name('all.type');

    Route::group(['prefix' => 'payment'], function() {
        Route::get('/', 'PaymentTypeController@index')->name('paymenttype.list');
        Route::get('list', 'PaymentTypeController@paymenttypeDataTable')->name('paymenttype.list.datatable');

        Route::get('add', 'PaymentTypeController@add')->name('paymenttype.create');
        Route::post('add', 'PaymentTypeController@create')->name('paymenttype.create.post');

        Route::get('edit/{paymenttype}', 'PaymentTypeController@edit')->name('paymenttype.edit');
        Route::patch('edit/{paymenttype}', 'PaymentTypeController@update')->name('paymenttype.edit.post');

        Route::delete('delete/{paymenttype}', 'PaymentTypeController@delete')->name('paymenttype.destroy');
        Route::get('status/{paymenttype}', 'PaymentTypeController@status')->name('paymenttype.status');
    });


});
