@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal', 'enctype' => 'multipart/form-data']) !!}
@endif
<div class="box-body">
    <div class="form-group{{ $errors->has('plugin') ? ' has-error' : '' }}">
        {!! Form::label('plugin', trans('Plugin::plugin.inputs.one') , ['class' => 'col-lg-2 control-label']) !!}
        <div class="col-lg-6">
            <div class="input-group image-preview">
                <input type="text" class="form-control image-preview-filename" disabled="disabled">
                <span class="input-group-btn">
                    <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                        <span class="fa fa-remove"></span>
                        Clear
                    </button>
                    <div class="btn btn-primary image-preview-input">
                        <span class="fa fa-repeat"></span>
                        <span class="image-preview-input-title">
                            File Browse
                        </span>
                        {!! Form::file('plugin', array('class' => 'plugin')) !!}
                    </div>
                </span>
            </div>
            {!! $errors->first('plugin', '<span class="help-block">:message</span>') !!}
        </div>
    </div>
</div>
<div class="box box-info">
    <div class="box-body">
        <div class="form-group">
            <div class="col-sm-4 col-sm-offset-2">
                {{ Form::submit($submitButton, ['class' => 'btn btn-success']) }}
            </div>
        </div>
        <div class="clearfix"></div>
    </div><!-- /.box-body -->
</div><!--box-->
{{ Form::close() }}
@push('footerAssetPush')
<script type="application/javascript">
    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'right'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>
@endpush