<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/

namespace Modules\Product\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait ProductAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@product-edit')) {
            return '<a href="' . route('product.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Product::product.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@product-view')) {
            return '<a href="' . route('product.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Product::product.buttons.actions.view') . '"></i></a> ';
        }
        return '';
    }

    public function getStatusButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@product-status')) {
            if ($this->status == 0)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('product.status', $this) . " title='" . trans('Product::product.buttons.actions.status.active') . "'><i class='fa fa-play'></i></a> ";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('product.status', $this) . " title='" . trans('Product::product.buttons.actions.status.deactive') . "'><i class='fa fa-pause'></i></a> ";
        }

    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@product-delete')) {
            if ($this->user_id == auth()->id() || auth()->user()->hasrole(1)) {
                return '<a href="' . route('product.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger product-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Product::product.buttons.actions.delete') . '"></i></a> ';
            }
        }

        return "";
    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getStatusButtonAttribute().
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}