@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($product, [
        'method' => 'PATCH',
        'route' => ['product.edit.post', $product->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif

    <div class="box-body">
        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
            {!! Form::label('name', trans("Product::product.inputs.name"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('name', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
            {!! Form::label('amount', trans("Product::product.inputs.amount"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('amount', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('amount', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('note') ? ' has-error' : '' }}">

            {!! Form::label('note', trans("Product::product.inputs.note"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::textarea('note', null, ['class' => 'form-control textarea col-xs-12']) !!}
                {!! $errors->first('note', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('product.list', trans('Product::product.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script>
    $(".textarea").wysihtml5();
</script>
@endpush