<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/

Route::group(['Module' => 'Product', 'prefix' => 'admin/product', 'namespace' => '\Modules\Product\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'ProductController@index')->name('product.list');
    Route::get('list', 'ProductController@productDataTable')->name('product.list.datatable');

    Route::get('add', 'ProductController@add')->name('product.create');
    Route::post('add', 'ProductController@create')->name('product.create.post');

    Route::get('edit/{product}', 'ProductController@edit')->name('product.edit');
    Route::patch('edit/{product}', 'ProductController@update')->name('product.edit.post');

    Route::delete('delete/{product}', 'ProductController@delete')->name('product.destroy');
    Route::get('status/{product}', 'ProductController@status')->name('product.status');

});
