<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Quotation\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait QuotationAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@quotation-edit')) {
            return '<a href="' . route('quotation.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Quotation::quotation.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@quotation-view')) {
            return '<a href="' . route('quotation.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Quotation::quotation.buttons.actions.view') . '"></i></a> ';
        }
        return '';
    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@quotation-delete')) {
            return '<a href="' . route('quotation.destroy', $this) . '"
             data-method="delete"
             data-trans-button-cancel="Cancel"
             data-trans-button-confirm="Delete"
             data-trans-title="Are you sure?"
             class="btn btn-xs btn-danger quotation-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Quotation::quotation.buttons.actions.delete') . '"></i></a> ';
        }

        return "";
    }


    public function getActionButtonsAttribute()
    {
        return
            $this->getViewButtonAttribute().
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}
