@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Quotation::quotation.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Quotation::quotation.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('quotation.list') }}"><i class="fa fa-laptop"></i>{{ trans('Quotation::quotation.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Quotation::quotation.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    @roles(['1'])
                    <a href="{{ route('quotation.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Quotation::quotation.buttons.create') }}
                        </button>
                    </a>
                    @endroles
                    <table id="quotations-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th class="col-sm-1">{{ trans('Quotation::quotation.inputs.serial') }}#</th>
                            <th>{{ trans('Quotation::quotation.inputs.client') }}</th>
                            <th>{{ trans('Quotation::quotation.inputs.grand_total') }}</th>
                            <th>{{ trans('Quotation::quotation.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#quotations-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("quotation.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'serial', name: 'serial'},
                {data: 'client', name: 'client'},
                {data: 'grand_total', name: 'grand_total'},
                {data: 'actions', name: 'actions', quotationable: false, searchable: false}
            ],
            quotation: [[0, "desc"]],
            searchDelay: 500

        });
        
    });
</script>
@endpush
