<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html">
    <meta name="_token" content="{{csrf_token()}}">
    <link href="{{ url(get_isite_favicon()) }}" rel="shortcut icon">
    <title>{{ strip_tags(get_isite_sitename()) }}</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <style type="text/css">
        #page-wrap {
            width: 700px;
            margin: 0 auto;
            padding-top: 50px;
        }
        .center-justified {
            text-align: justify;
            margin: 0 auto;
            width: 30em;
        }
        /*ini starts here*/
        .list-group {
            padding-left: 0;
            margin-bottom: 15px;
            width: auto;
        }
        .list-group-item {
            position: relative;
            display: block;
            padding: 7.5px 10px;
            margin-bottom: -1px;
            background-color: #fff;
            border: 1px solid #ddd;
            /*margin: 2px;*/
        }
        table {
            border-spacing: 0;
            border-collapse: collapse;
            font-size: 12px;
        }
        td,
        th {
            padding: 0;
        }
        @media print {
            * {
                color: #000 !important;
                text-shadow: none !important;
                background: transparent !important;
                box-shadow: none !important;
            }
            a,
            a:visited {
                text-decoration: underline;
            }
            a[href]:after {
                content: " (" attr(href) ")";
            }
            abbr[title]:after {
                content: " (" attr(title) ")";
            }
            a[href^="javascript:"]:after,
            a[href^="#"]:after {
                content: "";
            }
            pre,
            blockquote {
                border: 1px solid #999;

                page-break-inside: avoid;
            }
            thead {
                display: table-header-group;
            }
            tr,
            img {
                page-break-inside: avoid;
            }
            img {
                max-width: 100% !important;
            }
            p,
            h2,
            h3 {
                orphans: 3;
                widows: 3;
            }
            h2,
            h3 {
                page-break-after: avoid;
            }
            select {
                background: #fff !important;
            }
            .navbar {
                display: none;
            }
            .table td,
            .table th {
                background-color: #fff !important;
            }
            .btn > .caret,
            .dropup > .btn > .caret {
                border-top-color: #000 !important;
            }
            .label {
                border: 1px solid #000;
            }
            .table {
                border-collapse: collapse !important;
            }
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
            }
        }
        table {
            max-width: 100%;
            background-color: transparent;
            font-size: 12px;
        }
        th {
            text-align: left;
        }
        .table {
            width: 100%;
            margin-bottom: 10px;
        }
        .head {
            border-top: 0px solid #e2e7eb;
            border-bottom: 0px solid #e2e7eb;
        }
        .table > thead > tr > th,
        .table > tbody > tr > th,
        .table > tfoot > tr > th,
        .table > thead > tr > td,
        .table > tbody > tr > td,
        .table > tfoot > tr > td {
            padding: 5px;
            line-height: 1.428571429;
            vertical-align: top;
            border-top: 1px solid #e2e7eb;
        }
        /*ini edit default value : border top 1px to 0 px*/
        .table > thead > tr > th {
            font-size: 12px;
            font-weight: 500;
            vertical-align: bottom;
            color: #242a30;
        }

        .table > caption + thead > tr:first-child > th,
        .table > colgroup + thead > tr:first-child > th,
        .table > thead:first-child > tr:first-child > th,
        .table > caption + thead > tr:first-child > td,
        .table > colgroup + thead > tr:first-child > td,
        .table > thead:first-child > tr:first-child > td {
            border-top: 0;
        }
        .table > tbody + tbody {
            border-top: 2px solid #e2e7eb;
        }
        .table .table {
            background-color: #fff;
        }
        .table-condensed > thead > tr > th,
        .table-condensed > tbody > tr > th,
        .table-condensed > tfoot > tr > th,
        .table-condensed > thead > tr > td,
        .table-condensed > tbody > tr > td,
        .table-condensed > tfoot > tr > td {
            padding: 5px;
        }
        .table-bordered {
            border: 1px solid #e2e7eb;
        }
        .table-bordered > thead > tr > th,
        .table-bordered > tbody > tr > th,
        .table-bordered > tfoot > tr > th,
        .table-bordered > thead > tr > td,
        .table-bordered > tbody > tr > td,
        .table-bordered > tfoot > tr > td {
            border: 1px solid #e2e7eb;
        }
        .table-bordered > thead > tr > th,
        .table-bordered > thead > tr > td {
            border-bottom-width: 2px;
        }
        .table-striped > tbody > tr:nth-child(odd) > td,
        .table-striped > tbody > tr:nth-child(odd) > th {
            background-color: #f0f3f5;
        }
        .panel-title {
            margin-top: 0;
            margin-bottom: 0;
            font-size: 16px;
            color: #fff;
            padding: 0;
        }
        .panel-title > a {
            color: #707478;
            text-decoration: none;
        }
        a {
            background: transparent;
            color: #707478;
            text-decoration: none;
        }
        strong {
            color: #707478;
        }

        .total {
            float: left;
            color: #232A3F;
            margin-left: 80px;
            font-weight: 200;
        }

        .lead {
            font-size: 16px;
        }
        address {
            font-size: 14px;
        }
    </style>
</head>
<body>

<div id="page-wrap">
    <table width="100%">
        <tr>
            <td width="5%">
                @if(get_logo() != null)<img src="{{ url(get_logo()) }}" height="50px" class="pull-left thumb-xs m-r-sm">@endif
            </td>
        </tr>
        <tr style="padding: 0;margin: 0;">
            <td width="75%" >
                <h2 style="font-weight: 200">
                    {!! isite()->siteName()."<br>". isite()->sitePhone()."<br>".isite()->siteAddress()."<br>".isite()->siteCity().', '.isite()->siteState().', '.isite()->siteCountry()."<br>".isite()->siteEmail() !!}
                </h2>
            </td>
            <td width="25%">
                <h2 style="font-weight: 200">{!! strtoupper(trans("Quotation::quotation.module"))."<br>"."<b>#".$quotation->serial."</b>" !!} </h2>
            </td>
        </tr>
    </table>
    <hr>
    <table width="100%">
        <tr>
            <td width="50%">
                <h2>{{ trans('Quotation::quotation.view.to') }}</h2>
                <address>
                    <strong>{{ $client->name }}</strong><br>
                    @if(isset($company->company)){{ $company->company }}<br>@endif
                    @if($company->phone){{ $company->phone }}<br>@endif
                    @if($company->address_line_one){{ $company->address_line_one. ', '. $company->address_line_two }}<br>@endif
                    @if($company->city){{ $company->city. ', '. $company->state.', '.$company->zip_code.', '.$company->country }}<br>@endif
                    {{ $client->email }}
                </address>
            </td>
            <td width="50%">
                <h2>{{ trans('Quotation::quotation.view.info') }}</h2>
                <table class="table table-striped table-bordered" width="100%">
                    <tbody>
                        <tr>
                            <th>{{ trans('Quotation::quotation.inputs.quotation_no') }}</th>
                            <td>#{{ $quotation->serial }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('Quotation::quotation.inputs.quotation_id') }}</th>
                            <td>#{{ $quotation->id }}</td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </table>
    <br /><br />

    <table class="table table-striped table-bordered">
        <thead>
        <tr>
            <th data-title="{{ trans('Quotation::quotation.table.name') }}">{{ trans('Quotation::quotation.table.name') }}</th>
            <th data-title="{{ trans('Quotation::quotation.table.amount') }}">{{ trans('Quotation::quotation.table.amount') }}</th>
            <th data-title="{{ trans('Quotation::quotation.table.quantity') }}">{{ trans('Quotation::quotation.table.quantity') }}</th>
            <th data-title="{{ trans('Quotation::quotation.table.subtotal') }}">{{ trans('Quotation::quotation.table.subtotal') }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($quotation->products as $product)
            <tr>
                <td data-title="{{ trans('Quotation::quotation.table.name') }}" class="table-name">{{$product->name}}</td>
                <td  data-title="{{ trans('Quotation::quotation.table.amount') }}" class="table-price">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->price, 2)}}</td>
                <td  data-title="{{ trans('Quotation::quotation.table.quantity') }}" class="table-qty">{{$product->quantity}}</td>
                <td data-title="{{ trans('Quotation::quotation.table.subtotal') }}" class="table-total text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->quantity * $product->price, 2)}}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <table width="100%">
        <tbody>
        <tr>
            <td width="40%"></td>
            <td width="60%" style="float: right;">
                <table class="table table-bordered">
                    <tfoot>
                    <tr>
                        <th class="table-label">Sub Total</th>
                        <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->sub_total, 2)}}</td>
                    </tr>
                    <tr>
                        <th class="table-label">Discount</th>
                        <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->discount, 2)}}</td>
                    </tr>
                    <tr>
                        <th class="table-label">Tax</th>
                        <td class="table-amount text-right">
                            @if(isset($tax))
                                @if($tax->type == 1)
                                    %
                                @else
                                    {{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}
                                @endif
                                {{$tax->rate}}
                            @else
                                0.00
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th class="table-label">Grand Total</th>
                        <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->grand_total, 2) }}</td>
                    </tr>
                    </tfoot>
                </table>
            </td>
        </tr>
        </tbody>
    </table>
    <table>
        <tr>
            <td>
                <b>{{ trans("Quotation::quotation.inputs.note") }}:</b>
                <p class="text-muted well well-sm no-shadow">
                    {{ $quotation->note }}
                </p>
            </td>
        </tr>
    </table>
    <br>
</div>


</body>
</html>