@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Report::report.title_expense') }}
@endsection
@section('moduleDescription')
    @if($request['from_date']) {{ Carbon\Carbon::parse($request['from_date'])->format('jS F Y') }}  - @endif
    @if($request['to_date']) {{ Carbon\Carbon::parse($request['to_date'])->format('jS F Y') }} @endif
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('expense.report.list') }}"><i class="fa fa-laptop"></i>{{ trans('Report::report.breadcrumb.first_expense') }}</a></li>
    <li class="active">{{ trans('Report::report.breadcrumb.second_expense') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <table id="reports-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Expense::expense.columns.purchased_by') }}</th>
                            <th>{{ trans('Expense::expense.columns.expense_type_id') }}</th>
                            <th>{{ trans('Expense::expense.columns.payment_type_id') }}</th>
                            <th>{{ trans('Expense::expense.columns.purchased_date') }}</th>
                            <th>{{ trans('Expense::expense.columns.purchased_amount') }}</th>
                        </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th colspan="5" class="text-right"> Total</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var from_date   = '{!! $request['from_date'] !!}';
        var to_date     = '{!! $request['to_date'] !!}';
        var user_id   = '{!! $request['user_id'] !!}';

        var t = $('#reports-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("expense.report.list.datatable") }}',
                method: 'POST',
                data: { from_date:from_date, to_date:to_date, user_id:user_id },
            },
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'purchased', name: 'purchased'},
                {data: 'expense_type_id', name: 'expense_type_id'},
                {data: 'payment_type_id', name: 'payment_type_id'},
                {data: 'purchased_date', name: 'purchased_date'},
                {data: 'purchased_amount', name: 'purchased_amount'}
            ],
            footerCallback: function( tfoot, data, start, end, display ) {
                var iTotalMarket = 0;
                for ( var i=0 ; i<data.length ; i++ )
                {
                    iTotalMarket += data[i]['purchased_amount']*1;
                }
                console.log(iTotalMarket);
                $(tfoot).find('th').eq(1).html( "{{isite()->siteCurrencySymbol()}}"+iTotalMarket );
            },
            order: [[0, "asc"]],
            searchDelay: 500

        });

    });
</script>
@endpush