@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Report::report.title_payment') }}
@endsection
@section('moduleDescription')
    @if($request['from_date']) {{ Carbon\Carbon::parse($request['from_date'])->format('jS F Y') }}  - @endif
    @if($request['to_date']) {{ Carbon\Carbon::parse($request['to_date'])->format('jS F Y') }} @endif
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('payment.report.list') }}"><i class="fa fa-laptop"></i>{{ trans('Report::report.breadcrumb.first_payment') }}</a></li>
    <li class="active">{{ trans('Report::report.breadcrumb.second_payment') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <table id="reports-table" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                                <th>Payment By</th>
                                <th>Payment Type</th>
                                <th>Transaction ID</th>
                                <th>Currency</th>
                                <th>Payment Date</th>
                                <th>Paid Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $total_paid = 0;?>
                            @foreach($payments as $payment)
                                <tr>
                                    <td>
                                        <a style='border: 1px solid; padding:2px;' href="{{route('invoice.view', $payment->invoice->id)}}"> {{ $payment->invoice->serial }}</a>
                                    </td>
                                    <td>{{ $payment->user->name }}</td>
                                    <td>{{ $payment->payment_type }}</td>
                                    <td>{{ $payment->transaction_id }}</td>
                                    <td>{{ $payment->currency_code }}</td>
                                    <td>{{ \Carbon\Carbon::parse($payment->paid_date)->format('jS F Y') }}</td>
                                    <td>{{ isite()->siteCurrencySymbol() }}{{ $payment->paid_amount }}</td>
                                    <?php $total_paid += $payment->paid_amount; ?>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="6" class="text-right"> Total</th>
                                <th> {{ isite()->siteCurrencySymbol() }}{{ $total_paid }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    {{--$(function() {--}}
        {{--$.ajaxSetup({--}}
            {{--headers: {--}}
                {{--'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')--}}
            {{--}--}}
        {{--});--}}
        {{--var from_date   = '{!! $request['from_date'] !!}';--}}
        {{--var to_date     = '{!! $request['to_date'] !!}';--}}
        {{--var client_id   = '{!! $request['client_id'] !!}';--}}

        {{--var t = $('#reports-table').DataTable({--}}
            {{--processing: true,--}}
            {{--serverSide: true,--}}
            {{--ajax: {--}}
                {{--url: '{{ route("payment.report.list.datatable") }}',--}}
                {{--method: 'POST',--}}
                {{--data: { from_date:from_date, to_date:to_date, client_id:client_id },--}}
            {{--},--}}
            {{--buttons: [--}}
                {{--'csv', 'excel', 'pdf', 'print', 'reset', 'reload'--}}
            {{--],--}}
            {{--columns: [--}}
                {{--{data: 'serial', name: 'serial'},--}}
                {{--{data: 'user', name: 'user'},--}}
                {{--{data: 'payment_type', name: 'payment_type'},--}}
                {{--{data: 'transaction_id', name: 'transaction_id'},--}}
                {{--{data: 'currency_code', name: 'currency_code'},--}}
                {{--{data: 'paid_date', name: 'paid_date'},--}}
                {{--{data: 'paid_amount', name: 'paid_amount'},--}}
            {{--],--}}
            {{--footerCallback: function( tfoot, data, start, end, display ) {--}}
                {{--var iTotalMarket = 0;--}}
                {{--for ( var i=0 ; i<data.length ; i++ )--}}
                {{--{--}}
                    {{--iTotalMarket += data[i]['paid_amount']*1;--}}
                {{--}--}}
                {{--console.log(iTotalMarket);--}}
                {{--$(tfoot).find('th').eq(1).html( "{{isite()->siteCurrencySymbol()}}"+iTotalMarket );--}}
            {{--},--}}
            {{--order: [[0, "asc"]],--}}
            {{--searchDelay: 500--}}

        {{--});--}}

    {{--});--}}
</script>
@endpush