@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Report::report.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Report::report.optional_title.create') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('report.list') }}"><i class="fa fa-laptop"></i>{{ trans('Report::report.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Report::report.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('Report::_form', ['submitButton' => trans('Report::report.buttons.add'), 'formFor' => 'create'])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
