<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Settings\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Modules\Settings\Requests\SettingsRequest;
use Modules\Settings\Requests\SocialRequest;
use Modules\Settings\Requests\ThemeSettingsRequest;
use Modules\Settings\Models\Settings;

use File, Config, Theme, Session, Alert, Image, App, Cache;

class SettingsController extends Controller
{

    public function index()
    {
        $all_countries = array("Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, the Democratic Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "France Metropolitan", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and Mc Donald Islands", "Holy See (Vatican City State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao, People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, The Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain", "Sri Lanka", "St. Helena", "St. Pierre and Miquelon", "Sudan", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "United States Minor Outlying Islands", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Wallis and Futuna Islands", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");
        $countries = array_combine($all_countries, $all_countries);
        $settings       = Settings::all()->pluck('value', 'option');
        $backendTheme   = $this->getThemeList('backend');
        if(!session()->has('tab')) {
            session(['tab' => 'settings']);
        }
        return view("Settings::settingsUpdate")
                    ->with([
                        'countries' => $countries,
                        'settings' => $settings,
                        'backendTheme' => $backendTheme,
                    ]);

    }

    public function update(SettingsRequest $request)
    {
        $inputs = array_except($request->all(), ['_method', '_token', 'sitefavicon', 'frontendlogo']);
        $inputs['havefrontend'] = 'no';

        if ($request->hasFile('sitefavicon')) {
            $inputs['sitefavicon'] = config('core.assets_path.image').'backend/favicon.png';
            Image::make($request->file('sitefavicon'))->resize(80, 80)->save(config('core.assets_path.image').'backend/favicon.png');
        }
        if ($request->hasFile('frontendlogo')) {
            $inputs['frontendlogo'] = config('core.assets_path.image').'frontend/logo.png';
            Image::make($request->file('frontendlogo'))->resize(80, 80)->save(config('core.assets_path.image').'frontend/logo.png');
        }
        
        $this->saveToDatabase($inputs);

        $this->removeCached();

        Alert::success(trans("Settings::settings.alert.update_success"), 'success');
        return redirect(route('settings'))->withTab('settings');
    }

    public function updateSocialite(SocialRequest $request)
    {
        $inputs = array_except($request->all(), ['_method', '_token']);

        $this->saveToDatabase($inputs);

        $this->removeCached();

        Alert::success(trans("Settings::settings.alert.update_success"), 'success');
        return redirect(route('settings'))->withTab('social');
    }

    public function updateThemeSettings(ThemeSettingsRequest $request)
    {
        $inputs = array_except($request->all(), ['_method', '_token', 'frontendlogo']);

        if ($request->hasFile('frontendlogo')) {
            $inputs['frontendlogo'] = config('core.assets_path.image').'frontend/logo.png';
            Image::make($request->file('frontendlogo'))->resize(80, 80)->save(config('core.assets_path.image').'frontend/logo.png');
        }
        $this->saveToDatabase($inputs);

        $this->removeCached();

        Alert::success(trans("Settings::settings.alert.update_success"), 'success');
        return redirect(route('settings'))->withTab('themesettings');
    }

    public function updateDebug(Request $request)
    {
        if(config('core.demosite')) {
            flash(trans('Core::demo.message'), 'warning');
            return redirect(route('settings'))->withTab('debug');
        }

        $this->setKeyInEnvironmentFileUsingEnvWithTrueFalse('APP_DEBUG', $request['debug']);
        Artisan::call('cache:clear');
        Config::set('app.debug', $request['debug']);
        Alert::success(trans("Settings::settings.alert.update_success"), 'success');
        return redirect(route('settings'))->withTab('debug');
    }

    public function updateSmtp(Request $request)
    {
        $inputs = $request->all();
        foreach ($inputs as $key => $value) {
            if(is_null($value) || $value == "") continue;
            $this->setKeyInEnvironmentFileUsingEnv($key, $value);
        }
        Artisan::call('cache:clear');
        return redirect(route('settings'))->withTab('smtp');
    }

    protected function getThemeList($themeFor)
    {
        $getAllFoldersName =  File::directories(base_path('Themes/'.$themeFor));
        $theme = [];
        foreach ($getAllFoldersName as $value) {
            $res = str_replace(base_path('Themes/'.$themeFor.'/'), '', $value);
            $theme[$res] = ucfirst($res);
        }

        return $theme;
    }

    protected function setKeyInEnvironmentFileUsingEnvWithTrueFalse($key, $value)
    {
        $envContent = file_get_contents(App::environmentFilePath());

        if(file_exists(App::environmentFilePath()) && strpos($envContent, $key) !== false) {
            file_put_contents(App::environmentFilePath(), str_replace(
                $key.'='.(env($key) ? 'true' : 'false'),
                $key.'='.($value),
                $envContent
            ));
        }
    }

    protected function setKeyInEnvironmentFileUsingEnv($key, $value)
    {
        $envContent = file_get_contents(App::environmentFilePath());

        if(file_exists(App::environmentFilePath()) && strpos($envContent, $key) !== false) {
            file_put_contents(App::environmentFilePath(), str_replace(
                $key.'='.(is_null(env($key)) ? 'null' : env($key)),
                $key.'='.$value,
                $envContent
            ));
        }
    }

    public function removeCached()
    {
        Cache::forget('settings');
    }

    public function saveToDatabase($inputs)
    {
        foreach ($inputs as $option => $value) {
            Settings::updateOrInsert(['option' => $option],['value' => $value]);
        }
    }

}
