<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Settings\Requests;

use App\Http\Requests\Request;

class ThemeSettingsRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        session(['tab' => 'themesettings']);
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'frontendsitename' => 'required',
                    'frontendsiteemail' => 'email',
                    'logo' => 'dimensions:width=81,height=80'
                ];
            }
            default:break;
        }
    }
}
