{!! Form::model($settings, [

    'method' => 'PATCH',

    'route' => ['theme.update'],

    'class' => '',

    'enctype' => 'multipart/form-data'

]) !!}



    <div class="form-group col-lg-6 {{ $errors->has('frontendsitename') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendsitename', trans('Settings::settings.inputs.frontend.frontendsitename'), ['class' => '']) !!}

            {!! Form::text('frontendsitename', null, ['class' => 'form-control', 'required' => 'required']) !!}

            {!! $errors->first('frontendsitename', '<span class="help-block">:message</span>') !!}

    </div>



    <div class="form-group col-lg-6 {{ $errors->has('frontendsiteemail') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendsiteemail', trans('Settings::settings.inputs.frontend.frontendsiteemail'), ['class' => '']) !!}

            {!! Form::text('frontendsiteemail', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendsiteemail', '<span class="help-block">:message</span>') !!}

    </div>



    <div class="form-group col-lg-6 {{ $errors->has('frontendsitesubtitle') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendsitesubtitle', trans('Settings::settings.inputs.frontend.frontendsitesubtitle'), ['class' => '']) !!}

            {!! Form::text('frontendsitesubtitle', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendsitesubtitle', '<span class="help-block">:message</span>') !!}

    </div>



    <div class="form-group col-lg-6 {{ $errors->has('frontendfooter') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendfooter', trans('Settings::settings.inputs.frontend.frontendfooter'), ['class' => '']) !!}

            {!! Form::text('frontendfooter', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendfooter', '<span class="help-block">:message</span>') !!}

    </div>


    <div class="form-group col-lg-6 {{ $errors->has('frontendfacebooklink') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendfacebooklink', trans('Settings::settings.inputs.frontend.frontendfacebooklink'), ['class' => '']) !!}

            {!! Form::text('frontendfacebooklink', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendfacebooklink', '<span class="help-block">:message</span>') !!}

    </div>



    <div class="form-group col-lg-6 {{ $errors->has('frontendgooglelink') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendgooglelink', trans('Settings::settings.inputs.frontend.frontendgooglelink'), ['class' => '']) !!}

            {!! Form::text('frontendgooglelink', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendgooglelink', '<span class="help-block">:message</span>') !!}

    </div>



    <div class="form-group col-lg-6 {{ $errors->has('frontendtwitterlink') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendtwitterlink', trans('Settings::settings.inputs.frontend.frontendtwitterlink'), ['class' => '']) !!}

            {!! Form::text('frontendtwitterlink', null, ['class' => 'form-control']) !!}

            {!! $errors->first('frontendtwitterlink', '<span class="help-block">:message</span>') !!}

    </div>


    <div class="form-group col-lg-6 {{ $errors->has('frontendlogo') ? ' has-error' : '' }} has-feedback">

            {!! Form::label('frontendlogo', trans('Settings::settings.inputs.frontend.logo'), ['class' => '']) !!}

            <div class="input-group image-preview">
                <input type="text" class="form-control image-preview-filename" disabled="disabled">
                <span class="input-group-btn">
                    <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                        <span class="fa fa-remove"></span>
                        Clear
                    </button>
                    <div class="btn btn-primary image-preview-input">
                        <span class="fa fa-repeat"></span>
                        <span class="image-preview-input-title">
                            File Browse
                        </span>
                        {!! Form::file('frontendlogo', array('class' => 'logo ')) !!}
                    </div>
                </span>
            </div>

            {!! $errors->first('frontendlogo', '<span class="help-block">:message</span>') !!}

    </div>

    <div class="form-group{{ $errors->has('frontendabout') ? ' has-error' : '' }} col-lg-12">

        {!! Form::label('frontendabout', trans('Settings::settings.inputs.frontend.frontendabout'), ['class' => '']) !!}

        {!! Form::textarea('frontendabout', null, ['class' => 'form-control textarea']) !!}
        {!! $errors->first('frontendabout', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-3">

            {!! Form::submit($submitButton, ['class' => 'btn btn-success form-control']) !!}

    </div>

{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script type="application/javascript">
    $(".textarea").wysihtml5();

    $(document).on('click', '#close-preview', function(){ 
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
            function () {
               $('.image-preview').popover('show');
               $('.content').css('padding-bottom', '100px');
            }, 
             function () {
               $('.image-preview').popover('hide');
               $('.content').css('padding-bottom', '20px');
            }
        );    
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'right'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse"); 
        }); 
        // Create the preview image
        $(".image-preview-input input:file").change(function (){     
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });      
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);            
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }        
            reader.readAsDataURL(file);
        });  
    });

</script>
@endpush