@role(1)
    @extends('backend::pages.module')

    @section('moduleTitle')
        <i class="fa fa-cog"></i> {{ trans('Settings::settings.title') }}
    @endsection
    @section('moduleDescription')
        {{ trans('Settings::settings.optional_title.edit') }}
    @endsection

    @section('moduleBreadcrumb')
        <li><a href="{{ route('settings') }}"><i class="fa fa-cog"></i>{{ trans('Settings::settings.breadcrumb.first') }}</a></li>
        <li class="active">{{ trans('Settings::settings.breadcrumb.second') }}</li>
    @endsection

    @section('moduleContent')
        {{--{{ dd($user->id) }}--}}
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <section class="content-header">
                            <h1 class="box-title">
                                @yield('moduleTitle', 'New Monule')
                                <small>@yield('moduleDescription', 'Optional description')</small>
                            </h1>
                            <ol class="breadcrumb">
                                @yield('moduleBreadcrumb', '
                                     <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                     <li class="active">Here</li>
                                ')
                            </ol>
                        </section>
                    </div>
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="{{ session('tab') == 'settings' ? 'active' : ''}}"><a href="#settings" data-toggle="tab" aria-expanded="true">{{ trans('Settings::settings.tabs.backend') }}</a></li>
                                {{--<li class="{{ session('tab') == 'themesettings' ? 'active' : ''}}"><a href="#theme_settings" data-toggle="tab" aria-expanded="false">{{ trans('Settings::settings.tabs.frontend') }}</a></li>--}}
                                {{--<li class="{{ session('tab') == 'social' ? 'active' : ''}}"><a href="#socialite" data-toggle="tab" aria-expanded="false">{{ trans('Settings::settings.tabs.sociallite') }}</a></li>--}}
                                @if(file_exists(base_path('.env')))
                                    <li class="{{ session('tab') == 'debug' ? 'active' : ''}}"><a href="#debug" data-toggle="tab" aria-expanded="false">{{ trans('Settings::settings.tabs.debug') }}</a></li>
                                    <li class="{{ session('tab') == 'smtp' ? 'active' : ''}}"><a href="#smtp" data-toggle="tab" aria-expanded="false">{{ trans('Settings::settings.tabs.smtp') }}</a></li>
                                @endif
                                {{ get_all_binding_settings_tab() }}
                                <li class=""><a href="#tab" data-toggle="tab" aria-expanded="false">{{ session('data') }}</a></li>

                                <li class="pull-right"><a href="#" class="text-muted"><i class="fa fa-gear"></i></a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane {{ session('tab') == 'settings' ? 'active' : ''}}" id="settings">
                                    <div class="row">
                                        @include('Settings::_form',[
                                            'submitButton' => trans('Settings::settings.buttons.update'),
                                            'settings' => $settings,
                                            'langFrom' => [
                                                'system'        => trans('Settings::settings.inputs.backend.langFrom.system'),
                                                'browser_locale'    => trans('Settings::settings.inputs.backend.langFrom.browser_locale'),
                                                'geoIP_locale'      => trans('Settings::settings.inputs.backend.langFrom.geoIP_locale'),

                                            ]
                                        ])
                                    </div>
                                </div>
                                {{--<div class="tab-pane {{ session('tab') == 'themesettings' ? 'active' : ''}}" id="theme_settings">--}}
                                    {{--<div class="row">--}}
                                        {{--@include('Settings::_form_theme_settings',['submitButton' => trans('Settings::settings.buttons.update'), 'settings' => $settings])--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                                <!-- /.tab-pane -->
                                {{--<div class="tab-pane {{ session('tab') == 'social' ? 'active' : ''}}" id="socialite">--}}
                                    {{--<div class="row">--}}
                                        {{--@include('Settings::_form_socialite',['submitButton' => trans('Settings::settings.buttons.update_social_lite'), 'settings' => $settings])--}}
                                    {{--</div>--}}
                                {{--</div>--}}
                                <!-- /.tab-pane -->
                                @if(file_exists(base_path('.env')))
                                    <!-- /.tab-pane -->
                                    <div class="tab-pane {{ session('tab') == 'debug' ? 'active' : ''}}" id="debug">
                                        <div class="row">
                                            @include('Settings::_form_debug',['submitButton' => trans('Settings::settings.buttons.update'), 'settings' => ['debug' => env('APP_DEBUG') ? 'true' : 'false']])
                                        </div>
                                    </div>
                                    <!-- /.tab-pane -->

                                    <!-- /.tab-pane -->
                                    <div class="tab-pane {{ session('tab') == 'smtp' ? 'active' : ''}}" id="smtp">
                                        <div class="row">
                                            @include('Settings::_form_smtp',['submitButton' => trans('Settings::settings.buttons.update'), 'settings' => [
                                                'MAIL_HOST' => env('MAIL_HOST'),
                                                'MAIL_PORT' => env('MAIL_PORT'),
                                                'MAIL_USERNAME' => env('MAIL_USERNAME'),
                                                'MAIL_PASSWORD' => env('MAIL_PASSWORD'),
                                                'MAIL_ENCRYPTION' => env('MAIL_ENCRYPTION')
                                            ]])
                                        </div>
                                    </div>
                                    <!-- /.tab-pane -->
                                 @endif
                                {{ get_all_binding_settings_tab_content() }}
                            </div>
                            <!-- /.tab-content -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    @endsection
@endrole
