<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Tax\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Tax\Models\Tax;
use Modules\Tax\Repositories\TaxRepository;
use Modules\Tax\Requests\TaxRequest;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;

class TaxController extends Controller
{
    protected $taxRepo;

    function __construct(TaxRepository $tax)
    {
        $this->taxRepo = $tax;
    }

    public function index()
    {
        return view("Tax::taxList");
    }

    public function taxDataTable()
    {
        return DataTables::of($this->taxRepo->findAll(['*']))
            ->editColumn('rate', function ($tax){
                $type = $tax->type;
                if ($type == 1)
                    return $tax->rate. " %";
                elseif ($type == 2)
                    return $tax->rate. " $";
            })
            ->editColumn('type', function ($tax){
                $type = $tax->type;
                if ($type == 1)
                    return "Percentage";
                elseif ($type == 2)
                    return "Fixed";
            })
            ->editColumn('note', function ($tax){
                $lenth = strlen($tax->note);
                if ($lenth > 99)
                    return substr($tax->note, 0, 100)."...";
                else
                    return $tax->note;
            })
            ->addColumn('actions', function ($tax){
                return $tax->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        return view("Tax::taxCreate");
    }

    public function create(TaxRequest $request)
    {
        $input = $request->all();
        $result = $this->taxRepo->create($input);

        if ($result) {
            $this->removeCached();
            Alert::success(trans("Tax::tax.alert.update_success"), 'success');
            return redirect()->route('tax.list');
        }
    }

    public function edit(Tax $tax)
    {
        return view("Tax::taxEdit")->withTax($tax);
    }

    public function update(Tax $tax, TaxRequest $request)
    {
        $result = $this->taxRepo->update($tax, $request->all());

        if ($result) {
            $this->removeCached();
            Alert::success(trans("Tax::tax.alert.update_success"), 'success');
            return redirect()->route('tax.list');
        }
    }

    public function view(Tax $tax)
    {
        return $tax != null ? view("Tax::taxView")->withTax($tax) :  abort(404);
    }

    public function status(Tax $tax)
    {
        $data = [];
        if ($tax->status==1) {
            $data['status'] = 0;
        } else {
            $data['status'] = 1;
        }
        $this->taxRepo->update($tax->id, $data);
        $this->removeCached();
        Alert::success(trans("Tax::tax.alert.status_success"), 'success');

        return redirect()->route('tax.list');
    }

    public function delete(Tax $tax)
    {

    }

    public function removeCached()
    {
        Cache::forget('taxes');
    }


}
