<?php

namespace Modules\Tax\Requests;

use App\Http\Requests\Request;

class TaxRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required',
                    'rate' => 'required',
                    'type' => 'required',
                    'note' => 'max:250'
                    /*'exampleOne' => 'required|max:20|min:3|unique:users,username',
                    'exampleTwo' => 'required|email|unique:users,email',
                    'exampleThree' => 'required|min:5|confirmed',
                    'exampleFour' => 'required|same:password'*/
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'title' => 'required',
                    'rate' => 'required',
                    'type' => 'required',
                    'note' => 'max:250'
                    /*'exampleOne' => 'required|max:20|min:3|unique:users,username,'.$user->id.',id',
                    'exampleTwo' => 'required|email|unique:users,email,'.$user->email.',email',
                    'exampleThree' => 'min:5|confirmed',
                    'exampleFour' => 'same:password'*/
                ];
            }
            default:break;
        }
    }
}
