@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Tax::tax.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Tax::tax.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('tax.list') }}"><i class="fa fa-laptop"></i>{{ trans('Tax::tax.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Tax::tax.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    <a href="{{ route('tax.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Tax::tax.buttons.create') }}
                        </button>
                    </a>
                    {{--@endroles--}}
                    <table id="taxs-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Tax::tax.columns.title') }}</th>
                            <th>{{ trans('Tax::tax.columns.rate') }}</th>
                            <th>{{ trans('Tax::tax.columns.note') }}</th>
                            <th>{{ trans('Tax::tax.columns.type') }}</th>
                            <th>{{ trans('Tax::tax.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#taxs-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("tax.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'title', name: 'title'},
                {data: 'rate', name: 'rate'},
                {data: 'note', name: 'note'},
                {data: 'type', name: 'type'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "asc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush