<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Todo\Listeners\History;

/**
 * Class UserEventHistoryListener
 * @package Modules\Todo\Listeners\Todo
 */
class TodoEventHistoryListener
{
	/**
	 * @var string
	 */
	private $history_slug = 'Todo';

	/**
	 * @param $event
	 */
	public function onCreated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.todos.created") <strong>'.$event->todo->todo.'</strong>',
			$event->todo->id,
			'plus',
			'bg-green'
		);

	}

	/**
	 * @param $event
	 */
	public function onUpdated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.todos.updated") <strong>'.$event->todo->todo.'</strong>',
            $event->todo->id,
			'save',
			'bg-aqua'
		);
	}

	/**
	 * @param $event
	 */
	public function onDeleted($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.todos.deleted") <strong>'.$event->todo->todo.'</strong>',
            $event->todo->id,
			'trash',
			'bg-maroon'
		);
	}

	/**
	 * Register the listeners for the subscriber.
	 *
	 * @param  \Illuminate\Events\Dispatcher  $events
	 */
	public function subscribe($events)
	{
        $events->listen(
            \Modules\Todo\Events\History\TodoCreated::class,
            'Modules\Todo\Listeners\History\TodoEventHistoryListener@onCreated'
        );

        $events->listen(
            \Modules\Todo\Events\History\TodoUpdated::class,
            'Modules\Todo\Listeners\History\TodoEventHistoryListener@onUpdated'
        );

        $events->listen(
            \Modules\Todo\Events\History\TodoDeleted::class,
            'Modules\Todo\Listeners\History\TodoEventHistoryListener@onDeleted'
        );

	}
}