@extends('backend::layouts.login')

@include('backend::pages.asset.loginAndRegistrationHeaderAsset')

@section('content')


    <div class="login-logo">
        <a href="{{ url('/') }}">{!! isite()->siteName() !!}</a>
    </div><!-- /.login-logo -->
    @include('flash::message')
    <div class="box remove-border">
        <div class="login-box-body">
            <p class="login-box-msg">{!! trans("Iauth::login.signin_title") !!}</p>
            <!-- <div class="login-box-body"> -->
            <form method="POST" action="{{ route('admin.login.post') }}">

                {!! csrf_field() !!}

                <div class="form-group{{ $errors->has('emailorusername') ? ' has-error' : '' }} has-feedback">
                    <input type="text" class="form-control pl" placeholder="Username or Email" name="emailorusername" value="{{ old('emailorusername') }}">
                    <span class="fa fa-envelope-o form-control-feedback"></span>
                    @if ($errors->has('emailorusername'))
                        <span class="help-block">
                       <strong>{{ $errors->first('emailorusername') }}</strong>
                   </span>
                    @endif
                </div>

                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }} has-feedback">
                    <input type="password" class="form-control pl" placeholder="Password" name="password">
                    <span class="fa fa-key form-control-feedback"></span>

                    @if ($errors->has('password'))
                        <span class="help-block">
                       <strong>{{ $errors->first('password') }}</strong>
                   </span>
                    @endif
                </div>
                <div class="row">
                    <div class="col-xs-7">
                        <div class="checkbox icheck">
                            <label>
                                <input type="checkbox" class="flat-red"> {{ trans("Iauth::login.remember") }}
                            </label>
                        </div>
                    </div>
                    <div class="col-xs-5">
                        <a href="{{ route('admin.password.reset') }}" class="forget-label">{{ trans("Iauth::login.forget_password") }}</a>
                    </div>

                    <!-- /.col -->
                    <div class="col-xs-12">
                        <button type="submit" class="btn btn-primary btn-block btn-flat btn-lg">{{ trans("Iauth::login.signin") }}</button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>

            <div class="social-auth-links text-center">
                <p>- {{ trans('Iauth::login.signinor') }} -</p>
                <a href="{{ route('login.social','facebook') }}" class="btn btn-facebook"><i class="fa fa-facebook"></i></a>
                <a href="{{ route('login.social', 'google') }}" class="btn btn-google"><i class="fa fa-google-plus"></i></a>
                <a href="{{ route('login.social','github') }}" class="btn btn-github"><i class="fa fa-github"></i></a>
            </div><!-- /.social-auth-links -->
            @if(config('core.demosite'))
                @include('BackEndRoot::default.views.partials.demoLoginAccess')
            @endif
            <div class="social-auth-links text-center">
                <a href="http://inilabs.net" ><img src="{{ url(config('core.assets_path.image').'backend/inilabs.png') }}" width="200"></a>
            </div>
        <!-- <a href="{{ route('admin.register') }}" class="text-center">Register a new membership</a> -->
        </div>
        <a href="{{ route('admin.register') }}" >
            <div class="box-footer login-fotter">
                {{ trans('Iauth::login.register') }}
            </div>
        </a>
    <!-- /.login-box-body -->
    @include('backend::pages.asset.loginAndRegistrationFooterAsset')
@endsection