@extends('backend::layouts.master')

@include('backend::pages.asset.dashHeaderAsset')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Main content -->
        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                @role(1)
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-black"><i class="fa fa-usd"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">{{ trans('Iauth::dashboard.wid_income') }}</span>
                                <span class="info-box-number">{!!   $invoice_grand_total = array_sum($incomeMonthTotal) !!} </span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-red"><i class="fa fa-print"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">{{ trans('Iauth::dashboard.wid_invoice') }}</span>
                                <span class="info-box-number">{{ $total_invoice = $invoices->count() }}</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-blue"><i class="fa fa-dollar"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">{{ trans('Iauth::dashboard.wid_payments') }}</span>
                                <span class="info-box-number">{{ $payments->count() }}</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-aqua"><i class="fa fa-money"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">{{ trans('Iauth::dashboard.wid_expense') }}</span>
                                <span class="info-box-number">{{ $total_expense = array_sum($expenses) }}</span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                @endrole
                <!-- fix for small devices only -->
                <div class="clearfix visible-sm-block"></div>
            </div>
            <!-- /.row -->
            <!-- Main row -->
            @role(1)
            <div class="row">
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <i class="fa fa-area-chart"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.wid_chart_yearly') }}</h3>

                            <div class="box-tools pull-right">
                                <button class="btn btn-box-tool" type="button" id="earning_top_right_graph_back_btn">
                                    <i class="fa fa-arrow-left"></i>
                                </button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="earningGraph">

                                    </div>
                                    <!-- /.chart-responsive -->
                                </div>
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- ./box-body -->
                        <div class="box-footer">
                            <div class="row">
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <h5 class="description-header">{{ isite()->siteCurrencySymbol() }}{{$invoice_grand_total}}</h5>
                                        <span class="description-text">TOTAL INVOICE AMOUNT</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <h5 class="description-header">{{ isite()->siteCurrencySymbol() }}{{ $total_expense }}</h5>
                                        <span class="description-text">TOTAL EXPENSE</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block border-right">
                                        <h5 class="description-header">{{ isite()->siteCurrencySymbol() }}{{ $invoice_grand_total - $total_expense }}</h5>
                                        <span class="description-text">TOTAL PROFIT</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-xs-6">
                                    <div class="description-block">
                                        <h5 class="description-header">{{ $total_invoice }}</h5>
                                        <span class="description-text">TOTAL INVOICE</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.box-footer -->
                    </div>
                    <!-- /.box -->
                </div>
                <!-- /.col -->
            </div>
            @endrole
            <div class="row">
                <section class="col-lg-6">
                    <div class="box box-primary">
                        <div class="box-header">
                            <i class="ion ion-clipboard"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.wid_payments') }}</h3>
                        </div>
                        <div class="box-body scroll">
                            <table class="table no-margin">
                                <thead>
                                <tr>
                                    <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_by') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_type') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_date') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.paid_amount') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($payments  as $payment)
                                    <tr>
                                        <td>
                                            <a style='border: 1px solid; padding:2px;' href="{{ route('invoice.view', $payment->invoice->id) }}">
                                                {{ $payment->invoice->serial }}
                                            </a>
                                        </td>
                                        <td>{{ $payment->user->name }}</td>
                                        <td>{{ $payment->payment_type }}</td>
                                        <td>{{ $payment->paid_date ? Carbon\Carbon::parse($payment->paid_date)->format('jS F Y ') : '' }}</td>
                                        <td>{{ $payment->paid_amount }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
                <!-- Left col -->
                <section class="col-lg-6">
                    <div class="box box-success">
                        <div class="box-header">
                            <i class="fa fa-list-alt"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.wid_invoice') }}</h3>
                        </div>
                        <div class="box-body scroll">
                            <table class="table no-margin">
                                <thead>
                                <tr>
                                    <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                                    <th>{{ trans('Invoice::invoice.inputs.client') }}</th>
                                    <th>{{ trans('Invoice::invoice.inputs.due_date') }}</th>
                                    <th>{{ trans('Invoice::invoice.inputs.grand_total') }}</th>
                                    <th>{{ trans('Invoice::invoice.inputs.payment_status') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($invoices  as $invoice)
                                    <?php
                                    if($invoice->payment_status == "unpaid") {
                                        $btn = "btn-danger";
                                    } elseif ($invoice->payment_status == "paid") {
                                        $btn = "btn-success";
                                    } else {
                                        $btn = "btn-warning";
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <a style='border: 1px solid; padding:2px;' href="{{ route('invoice.view', $invoice->id) }}">
                                                {{ $invoice->serial }}
                                            </a>
                                        </td>
                                        <td>{{ $invoice->client->name }}</td>
                                        <td>{{ $invoice->due_date ? Carbon\Carbon::parse($invoice->due_date)->format('Y-m-d') : '' }}</td>
                                        <td>{{ $invoice->grand_total }}</td>
                                        <td><button class="btn {{$btn}} btn-xs">{{ $invoice->payment_status }}</button></td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </div>
            <div class="row">
                <section class="@role(1) col-lg-6 @else col-lg-12 @endrole connectedSortable">
                    <!-- TO DO List -->
                    <div class="box box-primary">
                        <div class="box-header">
                            <i class="fa fa-pie-chart"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.invoice_chart') }}</h3>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="chart" id="sales-chart" style="height: 300px; position: relative;"></div>
                        </div>
                    </div>
                    <!-- /.box -->
                </section>
                @role(1)
                <section class="col-lg-6 connectedSortable">
                    <!-- TO DO List -->
                    <div class="box box-primary">
                        <div class="box-header">
                            <i class="fa fa-pie-chart"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.wid_bankBalance') }}</h3>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Bank Account</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($bankBalance as $bank)
                                    <?php
                                        $bankAmount = 0;
                                        $current_balance = $bank->ini_balance + $bank->deposits->sum('amount');
                                        foreach ($bank->bankPayments as $bankPayment) {
                                            $bankAmount += $bankPayment->payment->paid_amount;
                                        }
                                        $current_balance += $bankAmount;
                                    ?>
                                    <tr>
                                        <td>{{ $bank->bank_title }}</td>
                                        <td>{{ number_format($current_balance, 2) }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.box -->
                </section>
                @endrole
            </div>
            <div class="row">
                <!-- Left col -->
                <div class="col-md-4">
                    <!-- Widget: user widget style 1 -->
                    <div class="box box-widget widget-user-2">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <div class="widget-user-header bg-maroon" style="height: auto;">
                            <div class="widget-user-image">
                                <img class="img-circle" src="{{ url($user->img) }}" alt="User Avatar">
                            </div>
                            <!-- /.widget-user-image -->
                            <h3 class="widget-user-username">
                                @if($user->name==null)
                                    {{ $user->username  }}
                                @else
                                    {{ $user->name  }}
                                @endif
                            </h3>
                            <h5 class="widget-user-desc">{{ $user->username  }}</h5>
                        </div>
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#"><b>{{ trans("Iauth::user.profile-title") }}</b></a></li>
                                <li><a href="#">{{ trans("Iauth::user.columns.email") }} <span class="pull-right badge bg-blue">{{ $user->email }}</span></a></li>
                                @if(isset($client))
                                    <li><a href="#">{{ trans('Client::client.columns.company') }} <span class="pull-right badge bg-yellow">{{ $client->company }}</span></a></li>
                                @endif
                                <li><a href="#">{{ trans("Invoice::invoice.module") }} <span class="pull-right badge bg-green">{{ $user->invoices->count() }}</span></a></li>
                                <li><a href="#">{{ trans("Iauth::user.create_date") }} <span class="pull-right badge bg-red">{{ $user->created_at->toDayDateTimeString() }}</span></a></li>
                                <li>
                                    <a href="#">{{ trans("Iauth::user.columns.role") }}
                                        <span class="pull-right badge bg-blue">
                                    <?php
                                            $roles = [];
                                            if ($user->roles()->count() > 0) {
                                                foreach ($user->roles as $role) {
                                                    array_push($roles, $role->name);
                                                }
                                                echo implode("<br/>", $roles);
                                            } else {
                                                echo 'None';
                                            }
                                            ?>
                                </span>
                                    </a>
                                </li>
                            </ul>
                            <a href="{{ route('profile.edit', $user->username ?: $user->id) }}" class="btn btn-primary btn-block"><b>{{ trans('Iauth::user.buttons.actions.edit') }}</b></a>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    @include('backend::pages.asset.dashFooterAsset')
@endsection
@push('footerAssetPush')
<script>
    //DONUT CHART
    $(function () {
        var donut = new Morris.Donut({
            element: 'sales-chart',
            resize: false,
            colors: [ "#82b440", "#d81b60", '#57c8f1'],
            data: [
                {label: "{{ trans('Iauth::dashboard.invoice.paid') }}", value: "{{ $invoices->where('payment_status', 'paid')->count() }}"},
                {label: "{{ trans('Iauth::dashboard.invoice.partial') }}", value: "{{ $invoices->where('payment_status', 'partially paid')->count() }}"},
                {label: "{{ trans('Iauth::dashboard.invoice.unpaid') }}", value: "{{ $invoices->where('payment_status', 'unpaid')->count() }}"},
            ],
            hideHover: 'auto'
        });
    });
</script>
@endpush
@role(1)
@push('headerAssetPush')
<link rel="stylesheet" href="{{ url('bassets/plugins/highcharts/highcharts.css') }}">
@endpush
@push('footerAssetPush')
<script src="{{ url('bassets/plugins/highcharts/highcharts.js') }}"></script>
<script src="{{ url('bassets/plugins/highcharts/highcharts-more.js') }}"></script>
<script type="application/javascript">
    $(function() {
        LoadEarningMonthly();
        function LoadEarningMonthly()
        {

            $( '#earning_top_right_graph_title').html("Class Attendence Lang");
            $( "#earning_top_right_graph_back_btn" ).hide();
            $('#earningGraph').highcharts({
                chart: {
                    type: 'areaspline'
                },
                title: {
                    text: '<?=date('Y')?> Accounts Summary'
                },
                subtitle: {
                    text: 'Click month income or expense column to view daywise account summary.'
                },
                xAxis: {
                    categories: [
                        <?php
                        echo implode(',', pluck_bind($months, NULL, "'", "'"));
                        ?>
                    ],
                    title: {
                        text: 'Month',
                        align: 'low'
                    }
                },
                yAxis: {
                    min: 0,
                    title: {
                        text: 'Amount',
                        align: 'high'
                    },
                    labels: {
                        overflow: 'justify'
                    }
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.y}</b>'
                },
                plotOptions: {
                    bar: {
                        dataLabels: {
                            enabled: true
                        }
                    },
                    series: {
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function (e) {
                                    LoadDayWiseExpenseOrIncome(this.type, this.monthID, this.monthName, this.dayWiseData);
                                }
                            }
                        }
                    }
                },
                legend: {
                    layout: 'vertical',
                    align: 'left',
                    verticalAlign: 'top',
                    x: 0,
                    y: 0,
                    floating: true,
                    borderWidth: 1,
                    backgroundColor: ((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'),
                    shadow: true
                },
                credits: {
                    enabled: false
                },
                series: [{
                    name: 'Income',
                    data: [
                        <?php
                        foreach ($months as $key => $month) {
                            if(isset($incomeMonthTotal[$key])) {
                                echo "{y:".$incomeMonthTotal[$key].", monthID:'".$key."', monthName:'".$month."', 'dayWiseData': '".json_encode($incomeMonthAndDay[$key])."', 'type': 'income'},";
                            } else {
                                echo "{y:0},";
                            }
                        }
                        ?>
                    ],
                    color: 'rgb(87,200,241)'
                },{
                    name: 'Expense',
                    data: [
                        <?php
                        foreach ($months as $key => $month) {
                            if(isset($expenseMonthTotal[$key])) {
                                echo "{y:".$expenseMonthTotal[$key].", monthID:'".$key."', monthName:'".$month."', 'dayWiseData': '".json_encode($expenseMonthAndDay[$key])."', 'type': 'expense'},";
                            } else {
                                echo "{y:0},";
                            }
                        }
                        ?>
                    ],
                    color: 'rgb(216,27,96)'
                }]
            });
        }

        function LoadDayWiseExpenseOrIncome(type, monthID, monthName, dayWiseData)
        {
            $( '#earning_top_right_graph_title').html(monthName+" month "+type);
            $( "#earning_top_right_graph_back_btn" ).show();
            $( "#earning_top_right_graph_back_btn" ).unbind( "click" );
            $( "#earning_top_right_graph_back_btn" ).on( "click",  function() {
                LoadEarningMonthly();
            });
            var categories = [];
            var series = [];
            var chartDayWiseData = [];
            var color = '#000';
            var tooltipTitle = '';

            if(type == 'income') {
                color = 'rgb(87,200,241)';
                tooltipTitle = 'Income';
            } else {
                color = 'rgb(216,27,96)';
                tooltipTitle = 'Expense';
            }

            $.ajax({
                type: 'POST',
                url: "{{ route('day.wise.income.expense') }}",
                data: {"dayWiseData" : dayWiseData, 'type': type, 'monthID': monthID, 'monthName': monthName},
                dataType: "html",
                success: function(data) {
                    data = $.parseJSON(data);
//                      console.log(data);
                    $.each(data, function (i, value) {
                        // console.log(i);
                        categories.push('Day '+i);
                        chartDayWiseData.push(value);
                    });
                    $('#earningGraph').highcharts({
                        chart: {
                            type: 'areaspline'
                        },
                        title: {
                            text: monthName+" month "+type
                        },
                        subtitle: {
                            text: ''
                        },
                        xAxis: {
                            categories: categories,
                            title: {
                                text: null
                            }
                        },
                        yAxis: {
                            min: 0,
                            title: {
                                text: 'Amount',
                                align: 'high'
                            },
                            labels: {
                                overflow: 'justify'
                            }
                        },
                        tooltip: {
                            pointFormat: '{series.name}: <b>{point.y}</b>'
                        },
                        plotOptions: {
                            bar: {
                                dataLabels: {
                                    enabled: true
                                }
                            },
                            series: {
                                cursor: 'pointer',
                                point: {
                                    events: {
                                        click: function (e) {
                                            // LoadGraphPerSchool(day,this.zone);
                                        }
                                    }
                                }
                            }
                        },
                        legend: {
                            layout: 'vertical',
                            align: 'left',
                            verticalAlign: 'top',
                            x: 0,
                            y: 0,
                            floating: true,
                            borderWidth: 1,
                            backgroundColor: ((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'),
                            shadow: true
                        },
                        credits: {
                            enabled: false
                        },
                        series: [{
                            name: tooltipTitle,
                            data: chartDayWiseData,
                            color: color
                        }]
                    });
                }
            });
        }

    });


</script>
@endpush
@endrole