@extends('backend::layouts.login')

@include('backend::pages.asset.loginAndRegistrationHeaderAsset')

@section('content')


    <div class="login-logo">
        <a href="{{ url('admin') }}">{!! isite()->siteName() !!} </a>
    </div><!-- /.login-logo -->
    @include('flash::message')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif
    <div class="box remove-border">
        <div class="box-header with-border skin-black">
            {!! trans("Iauth::login.reset_password_title") !!}
        </div>
        <div class="box-body">
            <!-- <div class="login-box-body"> -->
            <form method="POST" action="{{ route('admin.password.reset.with.token.post') }}">

                {!! csrf_field() !!}

                <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }} has-feedback">
                    <input type="email" class="form-control" placeholder="Email" name="email" value="{{ old('email') }}">
                    <span class="fa fa-envelope-o form-control-feedback"></span>
                    @if ($errors->has('email'))
                        <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                    @endif
                </div>

                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }} has-feedback">
                    <input type="password" class="form-control" placeholder="Password" name="password">
                    <span class="fa fa-key form-control-feedback"></span>

                    @if ($errors->has('password'))
                        <span class="help-block">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                    @endif
                </div>

                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }} has-feedback">
                    <input type="password" class="form-control" placeholder="Retype password" name="password_confirmation">
                    <span class="fa fa-sign-in form-control-feedback"></span>
                    @if ($errors->has('password_confirmation'))
                        <span class="help-block">
                        <strong>{{ $errors->first('password_confirmation') }}</strong>
                    </span>
                    @endif
                </div>
                <div class="row">
                    <!-- /.col -->
                    <div class="col-xs-12">
                        <button type="submit" class="btn btn-primary btn-block btn-flat btn-lg">{{ trans("Iauth::login.reset") }}</button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>

            <div class="social-auth-links text-center">
                <p>- {{ trans('Iauth::login.signinor') }} -</p>
                <a href="{{ route('login.social','facebook') }}" class="btn btn-facebook"><i class="fa fa-facebook"></i></a>
                <a href="{{ route('login.social', 'google') }}" class="btn btn-google"><i class="fa fa-google-plus"></i></a>
                <a href="{{ route('login.social','github') }}" class="btn btn-github"><i class="fa fa-github"></i></a>

            </div><!-- /.social-auth-links -->
            <div class="social-auth-links text-center">
                <a href="http://inilabs.net" ><img src="{{ url(config('core.assets_path.image').'backend/inilabs.png') }}" width="200"></a>
            </div>
        <!-- <a href="{{ route('admin.register') }}" class="text-center">Register a new membership</a> -->
        </div>
        <a href="{{ route('admin.login') }}" >
            <div class="box-footer login-fotter">
                {{ trans('Iauth::login.already_registered') }}
            </div>
        </a>
    </div>
    <!-- /.login-box-body -->
    @include('backend::pages.asset.loginAndRegistrationFooterAsset')
@endsection
