<?php
use Modules\Iauth\Models\Access\User\User;
use Modules\Iauth\Models\Access\Role\Role;
use Modules\Notice\Models\Notice;
use Modules\Todo\Models\Todo;
use Modules\Post\Models\Post;
use Modules\Expense\Models\Expense;
/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

$factory->define(User::class, function (Faker\Generator $faker) {
    return [
        'username' => $faker->userName,
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'email' => $faker->safeEmail,
        'img' => $faker->imageUrl($width = 462, $height = 462, 'people'),
        'password' => bcrypt('123456'),
        'remember_token' => str_random(10),
        'confirmation_code' => str_random(10),
    ];
});

$factory->define(Notice::class, function (Faker\Generator $faker) {
    return [
        'title' => $faker->sentence(5),
        'body' => $faker->text(),
    ];
});
$factory->define(Post::class, function (Faker\Generator $faker) {
    $title = $faker->sentence(5);
    return [
        'title' => $title,
        'teaser' => $faker->sentence(3),
        'slug' => strtolower(str_replace(" ","-",$title)),
        'body' => $faker->paragraph(50),
        'img' => $faker->imageUrl($width = 693, $height = 300),
        'published_at' => $faker->date('Y-m-d h:i:s'),
        'status' => 0,
    ];
});

$factory->define(Todo::class, function (Faker\Generator $faker) {
    return [
        'todo' => $faker->sentence(5),
        'status' => $faker->boolean(15)
    ];
});



