<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CrateRolesAndPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(config('core.acl.roles_table'), function ($table) {
            $table->increments('id')->unsigned();
            $table->string('name')->unique();
            $table->boolean('all')->default(false);
            $table->smallInteger('sort')->default(0)->unsigned();
            $table->timestamps();
        });

        Schema::create(config('core.acl.assigned_roles_table'), function ($table) {
            $table->increments('id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->integer('role_id')->unsigned();

            /**
             * Add Foreign/Unique/Index
             */
            $table->foreign('user_id')
                ->references('id')
                ->on(config('core.acl.users_table'))
                ->onDelete('cascade');

            $table->foreign('role_id')
                ->references('id')
                ->on(config('core.acl.roles_table'))
                ->onDelete('cascade');
        });

        Schema::create(config('core.acl.permissions_table'), function ($table) {
            $table->increments('id')->unsigned();
            $table->string('name')->unique();
            $table->string('display_name');
            $table->string('description')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });

        Schema::create(config('core.acl.permission_role_table'), function ($table) {
            $table->increments('id')->unsigned();
            $table->integer('permission_id')->unsigned();
            $table->integer('role_id')->unsigned();

            /**
             * Add Foreign/Unique/Index
             */
            $table->foreign('permission_id')
                ->references('id')
                ->on(config('core.acl.permissions_table'))
                ->onDelete('cascade');

            $table->foreign('role_id')
                ->references('id')
                ->on(config('core.acl.roles_table'))
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        /**
         * Remove Foreign/Unique/Index
         */
        Schema::table(config('core.acl.roles_table'), function (Blueprint $table) {
            $table->dropUnique(config('core.acl.roles_table') . '_name_unique');
        });

        Schema::table(config('core.acl.assigned_roles_table'), function (Blueprint $table) {
            $table->dropForeign(config('core.acl.assigned_roles_table') . '_user_id_foreign');
            $table->dropForeign(config('core.acl.assigned_roles_table') . '_role_id_foreign');
        });

        Schema::table(config('core.acl.permissions_table'), function (Blueprint $table) {
            $table->dropUnique(config('core.acl.permissions_table') . '_name_unique');
        });

        Schema::table(config('core.acl.permission_role_table'), function (Blueprint $table) {
            $table->dropForeign(config('core.acl.permission_role_table') . '_permission_id_foreign');
            $table->dropForeign(config('core.acl.permission_role_table') . '_role_id_foreign');
        });

        /**
         * Drop tables
         */
        Schema::drop(config('core.acl.assigned_roles_table'));
        Schema::drop(config('core.acl.permission_role_table'));
        Schema::drop(config('core.acl.roles_table'));
        Schema::drop(config('core.acl.permissions_table'));
    }
}
