<?php

use Illuminate\Database\Seeder;
use Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract;

class ClientPermissionTableSeeder extends Seeder
{
    protected $permissionRepo;

    public function __construct(PermissionRepositoryContract $permission)
    {
        $this->permissionRepo = $permission;
    }
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->auto();

        $role   = Config::get('installer.role');
        $data   = [
            ['name'=> 'Client', 'all'=> 0, 'sort' => 3]
        ];

        $clientID     = $role::create($data[0]);

        $pemission      = Config::get('installer.permission');
        $allPermission  = $pemission::where('status', '=', 1)->get()->pluck('id', 'name')->all();

        $clientPermission[] = $allPermission['admin@todo'];
        $clientPermission[] = $allPermission['admin@todo-list'];
        $clientPermission[] = $allPermission['admin@todo-add'];
        $clientPermission[] = $allPermission['admin@todo-edit'];
        $clientPermission[] = $allPermission['admin@todo-delete'];
        $clientPermission[] = $allPermission['admin@todo-status'];
        $clientPermission[] = $allPermission['admin@notice'];
        $clientPermission[] = $allPermission['admin@notice-view'];
        $clientPermission[] = $allPermission['admin@notice-list'];
        $clientPermission[] = $allPermission['admin@invoice'];
        $clientPermission[] = $allPermission['admin@invoice-list'];
        $clientPermission[] = $allPermission['admin@invoice-view'];
        $clientPermission[] = $allPermission['admin@invoice-get_tax'];
        $clientPermission[] = $allPermission['admin@invoice-email-template'];
        $clientPermission[] = $allPermission['admin@invoice-payment'];
        $clientPermission[] = $allPermission['admin@invoice-payments'];
        $clientPermission[] = $allPermission['admin@invoice-payments-list'];
        $clientPermission[] = $allPermission['admin@invoice-paypal-cancel'];
        $clientPermission[] = $allPermission['admin@invoice-paypal-success'];
        $clientPermission[] = $allPermission['admin@invoice-pdf'];
        $clientPermission[] = $allPermission['admin@invoice-send'];
        $clientPermission[] = $allPermission['admin@invoice-twocheckout-cancel'];
        $clientPermission[] = $allPermission['admin@invoice-twocheckout-success'];
        $clientPermission[] = $allPermission['admin@quotation'];
        $clientPermission[] = $allPermission['admin@quotation-list'];
        $clientPermission[] = $allPermission['admin@quotation-view'];
        $clientPermission[] = $allPermission['admin@quotation-pdf'];
        $clientPermission[] = $allPermission['admin@quotation-send'];
        $clientPermission[] = $allPermission['admin@client-password-update'];
        $clientPermission[] = $allPermission['admin@client-view'];
        $clientID->attachPermissions($clientPermission);

    }


    public function auto()
    {
        $routeCollection = Route::getRoutes();

        $f                      = false;
        $allRouteLikeDatabase   = [];
        foreach ($routeCollection as $value) {
            $middleware         =   false;
            if ( isset($value->getAction()['middleware']) && is_array($value->getAction()['middleware']) ) {
                $middleware     =   in_array('acl', $value->getAction()['middleware']);
            }

            if ($middleware) {
                $permission                     =   [];
                $explodeUrl                     =   explode('/', $value->getpath());
                $countExplode                   =   count($explodeUrl);

                for ($i = 1; $i <= $countExplode; $i++) {
                    if($explodeUrl[$i-1][0] != '{') {
                        if($i == 1) {
                            $permission['name']             =   $explodeUrl[$i-1];
                            $permission['display_name']     =   ucfirst($explodeUrl[$i-1]);
                        } elseif($i==2 && $explodeUrl[$i-2] == 'admin') {
                            $permission['name']             .=   '@'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        } else {
                            $permission['name']             .=   '-'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        }

                    }
                }

                $allRouteLikeDatabase[]         =   $permission['name'];
                if(isset($permission)) {
                    $status = $this->permissionRepo->firstOrCreate($permission);
                }
                if ($status->wasRecentlyCreated) {
                    $f  =   true;
                }
            }
        }

        $deletePermissionFromDatabaseWithCheckRoutes   =   array_count_values(array_merge($this->permissionRepo->getAllPermissions()->pluck('name')->all(), $allRouteLikeDatabase));

        foreach ($deletePermissionFromDatabaseWithCheckRoutes as $name => $value) {
            if($value == 1) {
                $this->permissionRepo->deleteWithPermissionName($name);
                $f  =   true;
            }
        }
    }
}
