<?php

use Illuminate\Database\Seeder;
use Modules\Iauth\Models\Access\User\User;
use Modules\Notice\Models\Notice;
use Modules\Todo\Models\Todo;
use Modules\Post\Models\Post;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        factory(User::class, 15)->create()->each(function($user) {
            $user->roles()->sync([2]);
            $user->notices()->save(factory(Notice::class)->make());
            $user->todos()->save(factory(Todo::class)->make());

            auth()->loginUsingId(1);
            history()->log(
                'User',
                'trans("history.backend.users.created") <strong>'.$user->username.'</strong>',
                $user->id,
                'plus',
                'bg-green'
            );
        });
        factory(User::class, 15)->create()->each(function($user) {
            $user->roles()->sync([3]);

            auth()->loginUsingId(1);
            history()->log(
                'User',
                'trans("history.backend.users.created") <strong>'.$user->username.'</strong>',
                $user->id,
                'plus',
                'bg-green'
            );
            $this->attachClientInformation($user->id);
        });
    }

    private function attachClientInformation($user_id)
    {
        $faker = Faker\Factory::create();

        DB::table('clients')->insert([
            'company' => $faker->company,
            'user_id' => $user_id,
            'address_line_one' => $faker->streetAddress,
            'address_line_two' => $faker->streetAddress,
            'city' => $faker->city,
            'state' => $faker->city,
            'zip_code'=> $faker->postcode,
            'phone'=> $faker->phoneNumber,
            'country' => $faker->country,
        ]);
    }
}
