var app = new Vue({
  el: '#invoice',
  data: {
    isProcessing: false,
    form: new FormData(),
    errors: {},
    tax: 0,
    type: null
  },
  ready: function() {
    this.sortBy();
  },
  created: function () {
    Vue.set(this.$data, 'form', _form);
  },
  methods: {
    random: function () {
      this.form.serial = Math.floor(Math.random() * 1000000) + 1;
    },
    sortBy: function() {
      if(this.form.tax_id) {
        var url = $("#taxRate").attr('href') +'/'+ this.form.tax_id;
        this.$http.get(url)
          .then(function(response){
            if(response.data.type) {
              this.tax = response.data.rate;
              this.type = response.data.type;
            }
          });
      }
    },
    addItem: function() {
      var price = $('#product_id').val();
      if(price!='') {
        var name  = $('#product_id').children(":selected").attr("id");
        this.form.products.push({name: name, price: price, quantity: 1});
        $('#product_id').prop('selectedIndex', 0);
      }
    },
    addLine: function() {
      this.form.products.push({name: '', price: 0, quantity: 1});
    },
    remove: function(product) {
      this.form.products.$remove(product);
    },
    removeAll: function() {
      this.form.products = [{name: '', price: 0, quantity: 1}];
    },
    create: function(action) {
      this.isProcessing = true;
      var url = "add";
      var route = "view";
      this.form.action = action;
      this.$http.post(url, this.form)
        .then(function(response) {
          if(response.data.created) {
            window.location = route + '/'+ response.data.id;
          } else {
            this.isProcessing = false;
          }
        })
        .catch(function(response) {
          this.isProcessing = false;
          Vue.set(this.$data, 'errors', response.data);
        })
    },
    update: function(action) {
      this.isProcessing = true;
      var url = $("#route").attr('href');
      var route = "view";
      this.form.action = action;
      this.$http.put(url, this.form)
        .then(function(response) {
          if(response.data.updated) {
            window.location = response.data.url;
          } else {
            console.log(response);
            this.isProcessing = false;
          }
        })
        .catch(function(response) {
          this.isProcessing = false;
          Vue.set(this.$data, 'errors', response.data);
        })
    }
  },
  computed: {
    totalTax: function () {
      // return this.tax;
      if (this.type==1) {
        return (this.tax / 100) * this.subTotal;
      } else {
        return this.tax;
      }
    },
    subTotal: function() {
      return this.form.products.reduce(function(carry, product) {
        return carry + (parseFloat(product.quantity) * parseFloat(product.price));
      }, 0);
    },
    grandTotal: function() {
      return this.subTotal - parseFloat(this.form.discount) + this.totalTax;
    }
  }
})