<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
if (! function_exists('get_or_call')) {
    /**
     * If Cached have data then return otherwise get from database
     */
    function get_or_call($name , $query, $minutes = 60)
    {
        return \Cache::remember($name, $minutes, function () use($query) {
            return $query;
        });
    }
}

if (! function_exists('auth_user')) {
    /**
     * Cached Login Users Data
     */
    function auth_user()
    {
        return get_or_call('auth_user', auth()->user());
    }
}
