<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/

if (! function_exists('bind_settings_tab')) {
    /**
     * For Backend Asset url generate
     */
    function bind_settings_tab($tab, $lang)
    {
        $class = session('tab') == $tab ? 'active' : '';
        return '<li class="'.$class.'"><a href="#'.$tab.'" data-toggle="tab" aria-expanded="true">'.$lang.'</a></li>';
    }
}

if (! function_exists('bind_settings_tab_content')) {
    /**
     * For Backend Asset url generate
     */
    function bind_settings_tab_content($tab, $view, $submitButtonLang = 'Update', array $settingsData)
    {
        $data = ['submitButton' => $submitButtonLang, 'settings' => $settingsData];
        $class = session('tab') == $tab ? 'active' : '';
        $form = view($view)->with('submitButton', $data['submitButton'])->withSettings($data['settings'])->render();
        return '<div class="tab-pane '.$class.'" id="'.$tab.'">
                    <div class="row">'.
                        $form
                    .'</div>
                </div>';
    }
}

if (! function_exists('get_all_binding_settings_tab')) {
    /**
     * For Backend Settings Bind Tab
     */
    function get_all_binding_settings_tab()
    {
        echo get_all_binding_settings('bindSettingsTab');
    }
}

if (! function_exists('get_all_binding_settings_tab_content')) {
    /**
     * For Backend Settings Bind Content
     */
    function get_all_binding_settings_tab_content()
    {
        echo get_all_binding_settings('bindSettingsTabContent');
    }
}

if (! function_exists('get_all_active_modules')) {
    /**
     * For Get All Modules
     */
    function get_all_active_modules()
    {
        $getAllModules = array_map('class_basename', \File::directories(base_path('Modules')));
        $disableModules = config("module.disable");

        $modules = array_diff($getAllModules, $disableModules);

        return $modules;
    }
}

if (! function_exists('get_all_binding_settings')) {
    /**
     * For Get All Modules Settings Binding
     */
    function get_all_binding_settings($method)
    {
        $functions = [];
        if(is_dir(base_path('Modules'))) {

            $modules = get_all_active_modules();
            foreach ($modules as $module) {
                $class = "\\Modules\\".$module."\\Services\\Settings";
                if(class_exists($class)) {
                    $module = strtolower($module);
                    $functions[] = isite()->$module('settings')->$method();
                }
            }
        }
        return implode("\n", $functions);
    }
}