<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
if (! function_exists('bassets')) {
    /**
     * For Backend Asset url generate
     */
    function bassets($assets)
    {
        return url('bassets/'.$assets);
    }
}

if (! function_exists('fassets')) {
    /**
     * For Frontend Asset url generate
     */
    function fassets($assets)
    {
        return url('fassets/'.$assets);
    }
}

if (! function_exists('isite')) {
    /**
     * For Backend Instance. Connecting Database and backend blade view
     */
    function isite()
    {
        return new \Core\iSite;
    }
}


if (! function_exists('site')) {
    /**
     * For Frontend Instance. Connecting Database and frontend blade view
     */
    function site()
    {
        return new \Core\Site;
    }
}


if (! function_exists('get_site_have_frontend')) {
    /**
     * return bool that identify frontend have or not
     */
    function get_site_have_frontend()
    {
        return isite()->siteHaveFrontend();
    }
}

if (! function_exists('get_isite_sitesortname')) {
    /**
     * return string
     */
    function get_isite_sitesortname()
    {
        return preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", isite()->sitesortname());
    }
}

if (! function_exists('get_isite_sitename')) {
    /**
     * return string
     */
    function get_isite_sitename()
    {
        return preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", isite()->siteName());
    }
}

if (! function_exists('get_isite_right_footer')) {
    /**
     * return string
     */
    function get_isite_right_footer()
    {
        return isite()->footerRight();
    }
}

if (! function_exists('get_isite_favicon')) {
    /**
     * return string
     */
    function get_isite_favicon()
    {
        return isite()->favicon();
    }
}

if (! function_exists('get_isite_left_footer')) {
    /**
     * return string
     */
    function get_isite_left_footer()
    {
        return preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", isite()->footerLeft());
    }
}

if (! function_exists('get_isite_google_analytics')) {
    /**
     * return string
     */
    function get_isite_google_analytics()
    {
        return isite()->getGoogleAnalytics();
    }
}

