<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core;

use App;
use Config;
/**
 * Class Installer
 * @package App
 */
class Installer
{
    protected $driver;

    public function setDriver($value)
    {
        $this->driver = $value;
    }

    public function checkExtension($check)
    {
        $result = false;
        switch ($check) {
            case 'phpVersion':
                $result = version_compare(PHP_VERSION , "5.6.4", ">=");
                break;
            case 'pdoLibrary':
                $result = defined('PDO::ATTR_DRIVER_NAME');
                break;
            case 'mbstring':
                $result = extension_loaded('mbstring');
                break;
            case 'tokenizer':
                $result = extension_loaded('tokenizer');
                break;
            case 'xml':
                $result = extension_loaded('xml');
                break;
            case 'openssl':
                $result = extension_loaded('openssl');
                break;
            case 'gd':
                $result = extension_loaded('gd');
                break;
            case 'curl':
                $result = function_exists('curl_init') && defined('CURLOPT_FOLLOWLOCATION');
                break;
            case 'zip':
                $result = class_exists('ZipArchive');
                break;
        }

        return $result;
    }

    public function checkPermission($path)
    {
        $getPermission = substr(sprintf('%o', fileperms(base_path($path))), -4);
        if($getPermission >= 777) {
            return true;
        }

        return false;
    }

    public function getEnvKey($key)
    {
        $result = false;
        switch ($key) {
            case 'database':
                $result = 'DB_DATABASE';
                break;
            case 'username':
                $result = 'DB_USERNAME';
                break;
            case 'password':
                $result = 'DB_PASSWORD';
                break;
            case 'driver':
                $result = 'DB_CONNECTION';
                break;
            case 'host':
                $result = 'DB_HOST';
                break;
            case 'DB_DATABASE':
                $result = 'database';
                break;
        }

        return $result;
    }

    public function setInEnvironment($key, $value)
    {
        $this->setKeyInEnvironmentFileUsingEnv($this->getEnvKey($key), $value);
        // $this->setKeyInEnvironmentFileUsingConfig( $this->getEnvKey($key), 'database.connections.'.$this->driver.'.'.$key, $value ); // Except Driver replacing
    }

    protected function setKeyInEnvironmentFileUsingConfig($key, $configKey ,$value)
    {
        file_put_contents(App::environmentFilePath(), str_replace(
            $key.'='.Config::get($configKey),
            $key.'='.$value,
            file_get_contents(App::environmentFilePath())
        ));
    }

    protected function setKeyInEnvironmentFileUsingEnv($key, $value)
    {
        if(file_exists(App::environmentFilePath())) {
            file_put_contents(App::environmentFilePath(), str_replace(
                $key.'='.env($key),
                $key.'='.$value,
                file_get_contents(App::environmentFilePath())
            ));
        }
    }

    public function setInstallKeyOnEnv()
    {
        if(env('APP_INSTALL')) {
            file_put_contents(App::environmentFilePath(), str_replace(
                'APP_INSTALL='.(env('APP_INSTALL') ? 'true' : 'false'),
                'APP_INSTALL=true',
                file_get_contents(App::environmentFilePath())
            ));
        } else {
            file_put_contents(App::environmentFilePath(), str_replace(
                'APP_URL='.env('APP_URL'),
                "APP_URL=".env('APP_URL')."\nAPP_INSTALL=true",
                file_get_contents(App::environmentFilePath())
            ));
        }

    }
    
    
}