<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Middleware;

use Closure;
use Carbon\Carbon;

/**
 * Class LocaleMiddleware
 * @package App\Http\Middleware
 */
class LocaleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure                 $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        /**
         * Locale is enabled and allowed to be changed
         */
        if (config('locale.status')) {
            if (session()->has('locale') && in_array(session()->get('locale'), array_keys(config('locale.languages')))) {

                /**
                 * Set the Laravel locale
                 */
                app()->setLocale(session()->get('locale'));

                /**
                 * setLocale for php. Enables ->formatLocalized() with localized values for dates
                 */
                setLocale(LC_TIME, config('locale.languages')[session()->get('locale')][1]);

                /**
                 * setLocale to use Carbon source locales. Enables diffForHumans() localized
                 */
                Carbon::setLocale(config('locale.languages')[session()->get('locale')][0]);

                /**
                 * Set the session variable for whether or not the app is using RTL support
				 * for the current language being selected
				 * For use in the blade directive in BladeServiceProvider
                 */
                if (config('locale.languages')[session()->get('locale')][2]) {
                    session(['lang-rtl' => true]);
                } else {
                    session()->forget('lang-rtl');
                }
            } else {
                if (config('locale.browser_locale')) {
                    $locale = substr($request->server('HTTP_ACCEPT_LANGUAGE'), 0, 2);
                    if (in_array($locale, array_keys(config('locale.languages')))) {
                        /**
                         * Set the Laravel locale
                         */
                        app()->setLocale($locale);

                        /**
                         * setLocale for php. Enables ->formatLocalized() with localized values for dates
                         */
                        setLocale(LC_TIME, config('locale.languages')[$locale][1]);

                        /**
                         * setLocale to use Carbon source locales. Enables diffForHumans() localized
                         */
                        Carbon::setLocale(config('locale.languages')[$locale][0]);

                        /**
                         * Set the session variable for whether or not the app is using RTL support
                         * for the current language being selected
                         * For use in the blade directive in BladeServiceProvider
                         */
                        if (config('locale.languages')[$locale][2]) {
                            session(['lang-rtl' => true]);
                        } else {
                            session()->forget('lang-rtl');
                        }
                    }
                } elseif (config('locale.geoIP_locale')) {
//                    $ip = site()->getIpAddress();
                    $ip = '45.64.156.204';
                    if ($ip) {
                        $details = site()->ipDetails($ip);
                        if(isset($details->country)) {
                            $locale = site()->getLocalCode($details->country);
                        } else {
                            $locale = 'en';
                        }
                        /**
                         * Set the Laravel locale
                         */
                        app()->setLocale($locale);

                        /**
                         * setLocale for php. Enables ->formatLocalized() with localized values for dates
                         */
                        setLocale(LC_TIME, config('locale.languages')[$locale][1]);

                        /**
                         * setLocale to use Carbon source locales. Enables diffForHumans() localized
                         */
                        Carbon::setLocale(config('locale.languages')[$locale][0]);

                        /**
                         * Set the session variable for whether or not the app is using RTL support
                         * for the current language being selected
                         * For use in the blade directive in BladeServiceProvider
                         */
                        if (config('locale.languages')[$locale][2]) {
                            session(['lang-rtl' => true]);
                        } else {
                            session()->forget('lang-rtl');
                        }
                    }
                }

            }

        }

        return $next($request);
    }
}
