<?php

namespace Core\Providers\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\File;

class ModuleCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:module 
                            {name : Module Name} 
                            {--U|usertype : User Role Module}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Module Folder Structure';


    protected $module;

    protected $path;

    protected $option = '';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if(! is_dir(base_path('Modules'))) {
            $disable = $this->getStubs('module');
            File::put(base_path('config').'/module.php', $disable);
            File::makeDirectory(base_path('Modules'));
        }

        $this->module = ucfirst($this->argument('name'));

        $this->option = $this->option('usertype');

        if(is_dir(base_path('Modules').'/'.$this->module))
         return $this->error('Sorry Boss. '.$this->module.' module already exists!');

        $this->makeFolder();
        $this->makeStubs();

        $this->info($this->module.' Module Successfully Generated !!!');

    }

    public function makeFolder()
    {
        $this->path = base_path('Modules').'/'.$this->module.'/';
        File::makeDirectory($this->path);
        File::makeDirectory($this->path.'Controllers');
        File::makeDirectory($this->path.'Models');
        File::makeDirectory($this->path.'Requests');
        File::makeDirectory($this->path.'Lang');
        File::makeDirectory($this->path.'Lang/en');
        File::makeDirectory($this->path.'Views');
        File::makeDirectory($this->path.'Repositories');
        File::makeDirectory($this->path.'Migrations');
        File::makeDirectory($this->path.'Models/Traits');
        File::makeDirectory($this->path.'Models/Traits/Attribute');
        File::makeDirectory($this->path.'Models/Traits/Relationship');
    }

    public function makeStubs()
    {
        if($this->option('usertype')) {
            $this->option   = 'usertype/';

            $changePassword = $this->getStubs($this->option.'changePassword');
            File::put($this->path.'Views/changePassword.blade.php', $changePassword);
        }
        $routes = $this->getStubs($this->option.'routes');
        File::put($this->path.'routes.php', $routes);

        $controller = $this->getStubs($this->option.'controllers');
        File::put($this->path.'Controllers/'.$this->module.'Controller.php', $controller);

        $request = $this->getStubs($this->option.'requests');
        File::put($this->path.'Requests/'.$this->module.'Request.php', $request);

        $model = $this->getStubs($this->option.'models', $this->module);
        File::put($this->path.'Models/'.$this->module.'.php', $model);

        $view = $this->getStubs('views');
        File::put($this->path.'Views/index.blade.php', $view);

        $view = $this->getStubs($this->option.'viewList');
        File::put($this->path.'Views/'.strtolower($this->module).'List.blade.php', $view);

        $view = $this->getStubs('viewCreate');
        File::put($this->path.'Views/'.strtolower($this->module).'Create.blade.php', $view);

        $view = $this->getStubs('viewEdit');
        File::put($this->path.'Views/'.strtolower($this->module).'Edit.blade.php', $view);

        $view = $this->getStubs($this->option.'viewView');
        File::put($this->path.'Views/'.strtolower($this->module).'View.blade.php', $view);

        $view = $this->getStubs($this->option.'viewForm');
        File::put($this->path.'Views/_form.blade.php', $view);

        $lang = $this->getStubs($this->option.'lang');
        File::put($this->path.'Lang/en/'.strtolower($this->module).'.php', $lang);

        $repository = $this->getStubs('repository');
        File::put($this->path.'Repositories/'.$this->module.'Repository.php', $repository);

        $attribute = $this->getStubs('attribute');
        File::put($this->path.'Models/Traits/Attribute/'.$this->module.'Attribute.php', $attribute);

        $relationship = $this->getStubs($this->option.'relationship');
        File::put($this->path.'Models/Traits/Relationship/'.$this->module.'Relationship.php', $relationship);

        $migration = $this->getStubs($this->option.'migration');
        File::put($this->path.'Migrations/'.date('Y_m_d_His').'_create_'.strtolower($this->module).'s_table.php', $migration);

        // Create Laravel migration directory
        //File::put(base_path('database/migrations/').date('Y_m_d_His').'_create_'.strtolower($this->module).'s_table.php', $migration);

    }

    public function getStubs($value)
    {
        $file = File::get(__DIR__.'/stubs/'.$value.'.stub');
        $file = $this->replaceStubs($this->module,$file);
        return $file;
    }

    protected function replaceStubs($name, $file)
  	{
      $file = str_replace('DummyTitle', $name, $file);
      $file = str_replace('dummytitle', strtolower($name), $file);
  		return $file;
  	}

}
