<?php

namespace Core\Providers\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\File;

class ThemeCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:theme {for} {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Theme Folder Structure';


    protected $theme;

    protected $for;

    protected $path;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if(! is_dir(base_path('Themes'))) {
            File::makeDirectory(base_path('Themes'));
        }

        if(! is_dir(base_path('Themes/backend'))) {
            File::makeDirectory(base_path('Themes/backend'));
        }

        if(! is_dir(base_path('Themes/frontend'))) {
            File::makeDirectory(base_path('Themes/frontend'));
        }

        $this->theme = $this->argument('name');
        $this->for = $this->argument('for');

        if(is_dir(base_path('Themes').'/'.$this->for.'/'.$this->theme))
         return $this->error('Sorry Boss. '.ucfirst($this->theme).' theme already exists!');

        $this->makeFolder();
        $this->makeStubs();

        $this->info(ucfirst($this->theme).' Theme Folder Successfully Generated !!!');

    }

    public function makeFolder()
    {
        $this->path = base_path('Themes').'/'.$this->for.'/'.$this->theme.'/';
        File::makeDirectory($this->path);
        File::makeDirectory($this->path.'assets');
        File::makeDirectory($this->path.'assets/scss');
        File::makeDirectory($this->path.'assets/css');
        File::makeDirectory($this->path.'assets/js');
        File::makeDirectory($this->path.'assets/fonts');
        File::makeDirectory($this->path.'assets/img');
        File::makeDirectory($this->path.'assets/plugins');
        File::makeDirectory($this->path.'views');
        File::makeDirectory($this->path.'views/partials');
        File::makeDirectory($this->path.'views/layouts');
        File::makeDirectory($this->path.'views/pages');
        File::makeDirectory($this->path.'views/errors');
    }

    public function makeStubs()
    {
        $json = $this->getStubs('composer');
        File::put($this->path.'theme.json', $json);
    }

    public function getStubs($value)
    {
        $file = File::get(__DIR__.'/stubs/'.$value.'.stub');
        $file = $this->replaceStubs($this->theme, $file);
        return $file;
    }

    protected function replaceStubs($name, $file)
  	{
      $file = str_replace('DummyTitle', $name, $file);
  		return $file;
  	}

}
