<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Support\ServiceProvider;
use App, Validator;
/**
 * Class InstallerServiceProvider
 * @package Shipu\Installer
 */
class InstallerServiceProvider extends ServiceProvider
{

    /**
     *
     */
    public function boot()
    {
        $this->app['router']->middleware('installer', '\Core\Middleware\InstallerMiddleware');
        $this->app['router']->middleware('installerless', '\Core\Middleware\NotInstallMiddleware');

        Validator::extend('envato', 'Modules\Installer\Requests\EnvatoValidation@validateEnvato');
    }

    public function register()
    {
        $this->app->bind('installer', function()
        {
            return new \Core\Installer;
        });
    }
}