<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Http\Request;
use Illuminate\Support\ServiceProvider;
use View;
use Site;
use Cache;

class SiteServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if(is_dir(base_path('Core/src/Lang'))) {
            $this->loadTranslationsFrom(base_path('Core/src/Lang'),'Core');
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('isite', function()
        {
            return new \Core\iSite;
        });

        $this->app->bind('xss', function()
        {
            return new \Core\Xss;
        });

        foreach (glob(base_path('Core/src/Helpers/*.php')) as $filename){
            require_once($filename);
        }

        config([
            'services.facebook.redirect' => url('admin/login/facebook/callback'),
            'services.github.redirect' => url('admin/login/github/callback'),
            'services.google.redirect' => url('admin/login/google/callback')
        ]);

        $this->app->register(\Core\Providers\ModuleServiceProvider::class);
        $this->app->register(\Core\Providers\ThemeServiceProvider::class);
        $this->app->register(\Core\Providers\AclServiceProvider::class);
        $this->app->register(\Core\Providers\InstallerServiceProvider::class);
        $this->app->register(\Core\Providers\HistoryServiceProvider::class);
        $this->app->register(\Core\Providers\EventServiceProvider::class);
    }

}
