<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core;

use Modules\Settings\Models\Settings;
use Response;
use Cache;
use DB;
use Schema;

class iSite extends BaseSite
{
    protected $settings;

    public function __construct()
    {
        $this->settings = Cache::remember('settings', 60, function () {
            return Settings::all()->pluck('value', 'option');
        });
    }

    public function siteName()
    {
        return isset($this->settings['sitename']) ? $this->settings['sitename'] : '<b>i</b>Start';
    }

    public function favicon()
    {
        return isset($this->settings['sitefavicon']) ? $this->settings['sitefavicon'] : 'public/favicon.ico';
    }

    public function siteSortName()
    {
        return isset($this->settings['sitesortname']) ? $this->settings['sitesortname'] : '<b>B</b>A';
    }

    public function siteHaveFrontend()
    {
        return isset($this->settings['havefrontend']) ? $this->settings['havefrontend'] : 'no';
    }

    public function getSiteFrontendTheme()
    {
        return isset($this->settings['frontendtheme']) ? $this->settings['frontendtheme'] : config('core.frontendtheme');
    }

    public function getSiteBackendTheme()
    {
        return isset($this->settings['backendtheme']) ? $this->settings['backendtheme'] : config('core.backendtheme');
    }

    public function getGoogleAnalytics()
    {
        return isset($this->settings['analyticsgoogle']) && $this->settings['analyticsgoogle'] != '' ? $this->settings['analyticsgoogle'] : 'UA-61634883-4';
    }

    public function footerRight()
    {
        return "iBill v1.0";
    }

    public function footerLeft()
    {
        return isset($this->settings['sitefooter']) && $this->settings['sitefooter'] != null ? $this->settings['sitefooter'] : 'iNiLabs';
    }

    public function siteEmail()
    {
        return isset($this->settings['siteemail']) && $this->settings['siteemail'] != null ? $this->settings['siteemail'] : 'labs.ini@gmail.com';
    }

    public function sitePhone()
    {
        return isset($this->settings['sitephone']) && $this->settings['sitephone'] != null ? $this->settings['sitephone'] : '';
    }
    public function siteAddress()
    {
        return isset($this->settings['siteaddress']) && $this->settings['siteaddress'] != null ? $this->settings['siteaddress'] : '';
    }
    public function siteCity()
    {
        return isset($this->settings['sitecity']) && $this->settings['sitecity'] != null ? $this->settings['sitecity'] : '';
    }
    public function siteState()
    {
        return isset($this->settings['sitestate']) && $this->settings['sitestate'] != null ? $this->settings['sitestate'] : '';
    }
    public function siteCountry()
    {
        return isset($this->settings['sitecountry']) && $this->settings['sitecountry'] != null ? $this->settings['sitecountry'] : '';
    }
    public function siteCurrencyCode()
    {
        return isset($this->settings['site_currency_code']) && $this->settings['site_currency_code'] != null ? $this->settings['site_currency_code'] : 'USD';
    }
    public function siteCurrencySymbol()
    {
        return isset($this->settings['site_currency_symbol']) && $this->settings['site_currency_symbol'] != null ? $this->settings['site_currency_symbol'] : '$';
    }

}
