<?php

namespace Modules\Bank\Requests;

use App\Http\Requests\Request;

class BankRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'bank_title'    => 'required|max:120|min:3',
                    'description'   => 'max:250',
                    'ini_balance'   => 'required',
                    'holder_name'   => 'required|max:40|min:3',
                    'account_no'    => 'required|max:40|min:3',
                    'phone'         => 'max:15|min:3',
                    'web_url'         => 'url'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'bank_title'    => 'required|max:120|min:3',
                    'description'   => 'max:250',
                    'ini_balance'   => 'required',
                    'holder_name'   => 'required|max:40|min:3',
                    'account_no'    => 'required|max:40|min:3',
                    'phone'         => 'max:15|min:3',
                    'web_url'       => 'url'
                ];
            }
            default:break;
        }
    }
}
