@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($bank, [
        'method' => 'PATCH',
        'route' => ['bank.edit.post', $bank->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif

    <div class="box-body">
        <div class="form-group{{ $errors->has('bank_title') ? ' has-error' : '' }}">
            {!! Form::label('bank_title', trans("Bank::bank.inputs.bank_title"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('bank_title', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('bank_title', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('ini_balance') ? ' has-error' : '' }}">
            {!! Form::label('ini_balance', trans("Bank::bank.inputs.ini_balance"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('ini_balance', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('ini_balance', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('holder_name') ? ' has-error' : '' }}">
            {!! Form::label('holder_name', trans("Bank::bank.inputs.holder_name"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('holder_name', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('holder_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('account_no') ? ' has-error' : '' }}">
            {!! Form::label('account_no', trans("Bank::bank.inputs.account_no"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('account_no', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('account_no', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
            {!! Form::label('phone', trans("Bank::bank.inputs.phone"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('phone', null, ['class' => 'form-control']) !!}
                {!! $errors->first('phone', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('web_url') ? ' has-error' : '' }}">
            {!! Form::label('web_url', trans("Bank::bank.inputs.web_url"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('web_url', null, ['class' => 'form-control']) !!}
                {!! $errors->first('web_url', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">

            {!! Form::label('description', trans("Bank::bank.inputs.description"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::textarea('description', null, ['class' => 'form-control textarea col-xs-12']) !!}
                {!! $errors->first('description', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('bank.list', trans('Bank::bank.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script>
    $(".textarea").wysihtml5();
</script>
@endpush