@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Bank::bank.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Bank::bank.optional_title.edit') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('bank.list') }}"><i class="fa fa-laptop"></i>{{ trans('Bank::bank.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Bank::bank.breadcrumb.second') }}</li>
@endsection
@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('Bank::_form', ['submitButton' => trans('Bank::bank.buttons.update'), 'formFor' => 'edit', 'bank' => $bank])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
