@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-university"></i> {{ trans('Bank::bank.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Bank::bank.optional_title.transactions') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('bank.list') }}"><i class="fa fa-laptop"></i>{{ trans('Bank::bank.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Bank::bank.breadcrumb.second') }}</li>
@endsection


@section('moduleContent')
    <div class="row">
        <div class="col-md-4">
            <!-- Widget: user widget style 1 -->
            <div class="box box-widget widget-user">
                <!-- Add the bg color to the header using any of the bg-* classes -->
                <div class="widget-user-header bg-light-blue" style="height: auto;">
                    <h3 class="widget-user-username">{{ $bank->bank_title }}</h3>
                    <h5 class="widget-user-desc">{{ $bank->holder_name }}</h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked">
                        <li><a href="#">{{ trans("Bank::bank.columns.account_no") }} <span class="pull-right badge bg-info">{{ $bank->account_no }}</span></a></li>
                        <li><a href="#">{{ trans("Bank::bank.columns.created_at") }} <span class="pull-right badge bg-blue">{{ $bank->created_at->toDayDateTimeString() }}</span></a></li>
                        <li><a href="#">{{ trans("Bank::bank.columns.ini_balance") }} <span class="pull-right badge bg-black">{{ number_format($bank->ini_balance, 2) }}</span></a></li>
                        <li><a href="#">{{ trans("Bank::bank.columns.phone") }} <span class="pull-right badge btn-primary">{{ $bank->phone }}</span></a></li>
                        <li><a href="#">{{ trans("Bank::bank.columns.web_url") }} <span class="pull-right badge btn-primary">{{ $bank->web_url }}</span></a></li>
                        <li><a href="#"><b>{{ trans("Bank::bank.inputs.description") }}</b></a></li>
                        <li><a href="#">{!! $bank->description  !!}</a></li>
                    </ul>
                </div>
            </div>
            <!-- /.widget-user -->
        </div>
        <div class="col-lg-8">
            <div class="box">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                    </section>
                </div>
                <div class="box-body">
                    {{-- Tab Open--}}
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#deposit" data-toggle="tab" aria-expanded="true">Deposit</a></li>
                            <li class=""><a href="#bankPayment" data-toggle="tab" aria-expanded="true">Invoice Payment</a></li>
                        </ul>
                        <div class="tab-content">
                            <div  id="deposit" class="tab-pane active">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>attachment</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($bank->deposits as $deposit)
                                        <tr>
                                            <td>{{ number_format($deposit->amount, 2) }}</td>
                                            <td>{{ \Carbon\Carbon::parse($deposit->date)->format('Y-m-d') }}</td>
                                            <td>{!!  $deposit->description  !!}</td>
                                            <td><a target="_blank" class="btn btn-xs btn-info" href="{{url("public/assets/img/deposit/".$deposit->attach)}}" download>Download</a></td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div  id="bankPayment" class="tab-pane">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Invoice</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($bank->bankPayments as $bankPayment)
                                        <tr>
                                            <td><a style='border: 1px solid; padding:2px;' href="{{route('invoice.view', $bankPayment->payment->invoice_id)}}">{{$bankPayment->payment->invoice->serial}}</a></td>
                                            <td>{{ number_format($bankPayment->payment->paid_amount,2) }}</td>
                                            <td>{{ \Carbon\Carbon::parse($bankPayment->payment->paid_date)->format('Y-m-d') }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.tab-content -->
                    </div>

                    {{-- Tab End--}}
                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
