<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Bank', 'prefix' => 'admin/bank', 'namespace' => '\Modules\Bank\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'BankController@index')->name('bank.list');
    Route::get('list', 'BankController@bankDataTable')->name('bank.list.datatable');

    Route::get('add', 'BankController@add')->name('bank.create');
    Route::post('add', 'BankController@create')->name('bank.create.post');

    Route::get('edit/{bank}', 'BankController@edit')->name('bank.edit');
    Route::patch('edit/{bank}', 'BankController@update')->name('bank.edit.post');

    Route::delete('delete/{bank}', 'BankController@delete')->name('bank.destroy');
    Route::get('view/{bank}', 'BankController@view')->name('bank.view');
    Route::get('status/{bank}', 'BankController@status')->name('bank.status');

});
