<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Client\Controllers;

use App\Http\Controllers\Controller;
use Modules\Client\Models\Client;
use Modules\Client\Requests\ClientRequest;
use Modules\Iauth\Models\Access\Role\Role;
use Modules\Iauth\Models\Access\User\User;
use Modules\Iauth\Repositories\Access\User\UserRepositoryContract;
use Modules\Iauth\Requests\UpdateUserPasswordRequest;
use Modules\Invoice\Models\Invoice;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache, File, Image;

class ClientController extends Controller
{
    protected $userRepo;

    function __construct(UserRepositoryContract $client)
    {
        $this->userRepo = $client;
    }

    public function langUses()
    {
        return view("Client::index");
    }

    public function index()
    {
        return view("Client::clientList");
    }

    public function clientDataTable()
    {
        return DataTables::of($this->userRepo->getAllUsersByRole('Client'))
            ->addColumn('name', function ($client){
                  return $client->name;
            })
            ->addColumn('photo', function ($user) {
                return "<img class=\"img-circle\" src=\"".url($user->img)."\" alt=\"$user->name Img\" width=\"42\" hight=\"42\">";
            })
            ->addColumn('company', function ($client){
                return $client->hasOneRelation('Modules\Client\Models\Client')->first()['company'];
            })
            ->addColumn('actions', function ($client){
                $client->action_buttons = 'client';
                return $client->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        $all_countries = array("Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, the Democratic Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "France Metropolitan", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and Mc Donald Islands", "Holy See (Vatican City State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao, People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, The Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain", "Sri Lanka", "St. Helena", "St. Pierre and Miquelon", "Sudan", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "United States Minor Outlying Islands", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Wallis and Futuna Islands", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");
        $countries = array_combine($all_countries, $all_countries);
        return view("Client::clientCreate")->withCountries($countries);
    }

    public function create(ClientRequest $request)
    {
        $input = $request->all();
        $clientRoleID = Role::whereName('Client')->pluck('id');
        $role['assignees_roles'][] = $clientRoleID[0] ?: 0;
        $result = $this->userRepo->create($input, $role, 'Modules\Client\Models\Client');

        if ($result) {
            $this->removeCached();
            Alert::success(trans("Client::client.alert.update_success"), 'success');
            if($request->ajax()){
                return response()
                    ->json([
                        'created' => true,
                    ]);
            }
            return redirect()->route('client.list');
        }
    }

    public function edit(User $user)
    {
        $all_countries = array("Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, the Democratic Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "France Metropolitan", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and Mc Donald Islands", "Holy See (Vatican City State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao, People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, The Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain", "Sri Lanka", "St. Helena", "St. Pierre and Miquelon", "Sudan", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "United States Minor Outlying Islands", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Wallis and Futuna Islands", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");
        $countries = array_combine($all_countries, $all_countries);
        $relationTableData = $user->hasOneRelation('Modules\Client\Models\Client')->first();
        $inputFieldPairToModelRelation = [
            'company' => 'company',
            'phone' => 'phone',
            'address_line_one' => 'address_line_one',
            'address_line_two' => 'address_line_two',
            'city' => 'city',
            'zip_code' => 'zip_code',
            'state' => 'state',
            'country' => 'country',
            'client_id' => 'id'
        ];

        foreach ($inputFieldPairToModelRelation as $inputViewIndex => $relationIndex) {
            $user[$inputViewIndex] = $relationTableData[$relationIndex];
        }

        return view("Client::clientEdit")->withClient($user)->withCountries($countries);
    }

    public function update(User $user, Client $client, ClientRequest $request)
    {
        $request['status']          = $user->status;
        $request['is_valid_email']  = $user->is_valid_email;
        $this->removeCached();
        if ($request->hasFile('image')) {
            if(!is_dir(base_path(config('core.users.profile_image_path')))) {
                File::makeDirectory(base_path(config('core.users.profile_image_path')));
            }
            Image::make($request->file('image'))->resize(462, 462)->save(config('core.users.profile_image_path').$user->username.'.jpg');
            $request['img'] = config('core.users.profile_image_path').$user->username.'.jpg';
        }

        $result = $this->userRepo->update($user,
            $request->except('assignees_roles', 'image'),
            [],
            $client
        );

        if ($result) {
            $this->removeCached();
            Alert::success(trans("Client::client.alert.update_success"), 'success');
            return redirect()->route('client.list');
        }
    }

    public function updateProfile(User $user, Client $client, ClientRequest $request)
    {
        $request['status']          = $user->status;
        $request['is_valid_email']  = $user->is_valid_email;
        $this->removeCached();
        if ($request->hasFile('image')) {
            if(!is_dir(base_path(config('core.users.profile_image_path')))) {
                File::makeDirectory(base_path(config('core.users.profile_image_path')));
            }
            Image::make($request->file('image'))->resize(462, 462)->save(config('core.users.profile_image_path').$user->username.'.jpg');
            $request['img'] = config('core.users.profile_image_path').$user->username.'.jpg';
        }

        $result = $this->userRepo->update($user,
            $request->except('assignees_roles', 'image'),
            [],
            $client
        );

        if ($result) {
            $this->removeCached();
            Alert::success(trans("Iauth::user.alert.update_success"), 'success');
            return redirect(route('profile'));
        }
    }

    public function view($user)
    {
        if(is_numeric($user)) {
            $user = User::find($user);
            $relationTableData = $user->hasOneRelation('Modules\Client\Models\Client')->first();
            $invoices = Invoice::where('client_id', $user->id)->with('client')->orderBy('created_at', 'desc')->get();
            return $user != null ? view('Client::clientView')
                    ->withUser($user)
                    ->withClient($relationTableData)
                    ->withInvoices($invoices) :  abort(404);
        } else {
            $user               = User::where('username', '=', $user)->first();
            $relationTableData  = $user->hasOneRelation('Modules\Client\Models\Client')->first();
            $invoices = Invoice::where('client_id', $user->id)->with('client')->orderBy('created_at', 'desc')->get();

            return $user != null ? view('Client::clientView')
                    ->withUser($user)
                    ->withClient($relationTableData)
                    ->withInvoices($invoices) :  abort(404);
        }
    }

    /**
     * @param User $user
     * @param ManageUserRequest $request
     * @return mixed
     */
    public function changePassword(User $user)
    {
        return view('Client::changePassword')
            ->withUser($user);
    }

    /**
     * @param User $user
     * @param UpdateUserPasswordRequest $request
     * @return mixed
     */
    public function updatePassword(User $user, UpdateUserPasswordRequest $request)
    {
        if(config('core.demosite')) {
            Alert::warning('Disabled', trans('Core::demo.message'));
            return redirect()->back();
        }

        $this->userRepo->updatePassword($user, $request->all());
        $this->removeCached();
        Alert::success(trans("Iauth::user.alert.change_pass_success"), 'success');
        return redirect()->route('client.list');
    }


    public function removeCached()
    {
        Cache::forget('only_trashed_users');
        Cache::forget('active_user');
        Cache::forget('all_users');
        Cache::forget('get_user_by_role');
        Cache::forget('all_clients');
        Cache::forget('clients');
    }


}
