@if ($formFor == 'create')
    {!! Form::open([
        'class' => 'form-horizontal', 'enctype' => 'multipart/form-data'
    ]) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($client, [
        'method' => 'PATCH',
        'route' => ['client.edit.post', $client->id, $client->client_id],
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data'
    ]) !!}
@elseif ($formFor == 'editProfile')
    {!! Form::model($user, [
        'method' => 'PATCH',
        'route' => ['profile.client.edit.post', $user->id, $user->client_id],
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data'
    ]) !!}
@endif
    <div class="box-body">
        <div class="form-group{{ $errors->has('username') ? ' has-error' : '' }}">

            {!! Form::label('username', trans("Iauth::user.inputs.one"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('username', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('username', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">

            {!! Form::label('first_name',  trans("Iauth::user.inputs.two"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('first_name', null, ['class' => 'form-control']) !!}
                {!! $errors->first('first_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('last_name') ? ' has-error' : '' }}">

            {!! Form::label('last_name',  trans("Iauth::user.inputs.three"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('last_name', null, ['class' => 'form-control']) !!}
                {!! $errors->first('last_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">

            {!! Form::label('email',  trans("Iauth::user.inputs.four"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('email', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('email', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
            {!! Form::label('company', trans("Client::client.inputs.company"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('company', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('company', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
            {!! Form::label('phone', trans("Client::client.inputs.phone"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('phone', null, ['class' => 'form-control']) !!}
                {!! $errors->first('phone', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('address_line_one') ? ' has-error' : '' }}">
            {!! Form::label('address_line_one', trans("Client::client.inputs.address_line_one"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('address_line_one', null, ['class' => 'form-control']) !!}
                {!! $errors->first('address_line_one', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('address_line_two') ? ' has-error' : '' }}">
            {!! Form::label('address_line_two', trans("Client::client.inputs.address_line_two"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('address_line_two', null, ['class' => 'form-control']) !!}
                {!! $errors->first('address_line_two', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('city') ? ' has-error' : '' }}">
            {!! Form::label('city', trans("Client::client.inputs.city"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('city', null, ['class' => 'form-control']) !!}
                {!! $errors->first('city', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('state') ? ' has-error' : '' }}">
            {!! Form::label('state', trans("Client::client.inputs.state"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('state', null, ['class' => 'form-control']) !!}
                {!! $errors->first('state', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('zip_code') ? ' has-error' : '' }}">
            {!! Form::label('zip_code', trans("Client::client.inputs.zip_code"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('zip_code', null, ['class' => 'form-control']) !!}
                {!! $errors->first('zip_code', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('country') ? ' has-error' : '' }}">
            {!! Form::label('country', trans("Client::client.inputs.country"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::select('country', $countries, null, ['class' => 'form-control select2', 'required' => 'required']) !!}
                {!! $errors->first('country', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        @if ($formFor == 'create')
            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">

                {!! Form::label('password',  trans("Iauth::user.inputs.five"), ['class' => 'col-lg-2 control-label']) !!}

                <div class="col-lg-6">
                    {!! Form::password('password', ['class' => 'form-control']) !!}
                    {!! $errors->first('password', '<span class="help-block">:message</span>') !!}
                </div>
            </div>

            <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">

                {!! Form::label('password_confirmation', trans("Iauth::user.inputs.six"), ['class' => 'col-lg-2 control-label']) !!}

                <div class="col-lg-6">
                    {!! Form::password('password_confirmation', ['class' => 'form-control']) !!}
                    {!! $errors->first('password_confirmation', '<span class="help-block">:message</span>') !!}
                </div>
            </div>
        @endif
        <div class="form-group">

            {{ Form::label('image', trans("Iauth::user.inputs.ten"), ['class' => 'col-lg-2 control-label']) }}

            <div class="col-lg-6">
                <div class="input-group image-preview">
                    <input type="text" class="form-control image-preview-filename" disabled="disabled">
                    <span class="input-group-btn">
                    <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                        <span class="fa fa-remove"></span>
                        Clear
                    </button>
                    <div class="btn btn-primary image-preview-input">
                        <span class="fa fa-repeat"></span>
                        <span class="image-preview-input-title">
                            File Browse
                        </span>
                        {!! Form::file('image', null, ['class' => 'file']) !!}
                    </div>
                </span>
                </div>
                {!! $errors->first('image', '<span class="help-block">:message</span>') !!}
            </div>
        </div><!--form control-->

    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('client.list', trans('Client::client.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}
@push('headerAssetPush')
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<style type="text/css">
    .select2-container .select2-selection--single {
        height: 34px !important;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 0px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 34px !important;
    }
</style>
@endpush
@push('footerAssetPush')
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script>
    $('.select2').select2();
    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>
@endpush